/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiAndroidProvider;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.internal.ImageLoadingTask;
import com.vanniktech.emoji.internal.OnEmojiLongClickListener;
import com.vanniktech.emoji.internal.UtilsKt;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.variant.VariantEmoji;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J(\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020%H\u0014J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020#H\u0014J\b\u00100\u001a\u00020#H\u0002J\u001e\u00101\u001a\u00020#2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020#2\u0006\u00104\u001a\u00020\tR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/vanniktech/emoji/internal/EmojiImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentEmoji", "Lcom/vanniktech/emoji/Emoji;", "clickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "getClickListener$emoji_release", "()Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "setClickListener$emoji_release", "(Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;)V", "longClickListener", "Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;", "getLongClickListener$emoji_release", "()Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;", "setLongClickListener$emoji_release", "(Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;)V", "variantIndicatorPaint", "Landroid/graphics/Paint;", "variantIndicatorPath", "Landroid/graphics/Path;", "variantIndicatorTop", "Landroid/graphics/Point;", "variantIndicatorBottomRight", "variantIndicatorBottomLeft", "hasVariants", "", "imageLoadingTask", "Lcom/vanniktech/emoji/internal/ImageLoadingTask;", "onMeasure", "", "widthMeasureSpec", "", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDetachedFromWindow", "cancelFuture", "setEmoji", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "emoji", "variantEmoji", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "updateEmoji", "Companion", "emoji_release"})
public final class EmojiImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Emoji currentEmoji;
    @Nullable
    private OnEmojiClickListener clickListener;
    @Nullable
    private OnEmojiLongClickListener longClickListener;
    @NotNull
    private final Paint variantIndicatorPaint;
    @NotNull
    private final Path variantIndicatorPath;
    @NotNull
    private final Point variantIndicatorTop;
    @NotNull
    private final Point variantIndicatorBottomRight;
    @NotNull
    private final Point variantIndicatorBottomLeft;
    private boolean hasVariants;
    @Nullable
    private ImageLoadingTask imageLoadingTask;
    private static final int VARIANT_INDICATOR_PART_AMOUNT = 6;
    private static final int VARIANT_INDICATOR_PART = 5;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public EmojiImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$variantIndicatorPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        Paint paint2 = paint = new Paint();
        EmojiImageView emojiImageView = this;
        boolean bl = false;
        $this$variantIndicatorPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$variantIndicatorPaint_u24lambda_u240.setAntiAlias(true);
        emojiImageView.variantIndicatorPaint = paint;
        this.variantIndicatorPath = new Path();
        this.variantIndicatorTop = new Point();
        this.variantIndicatorBottomRight = new Point();
        this.variantIndicatorBottomLeft = new Point();
    }

    public /* synthetic */ EmojiImageView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @Nullable
    public final OnEmojiClickListener getClickListener$emoji_release() {
        return this.clickListener;
    }

    public final void setClickListener$emoji_release(@Nullable OnEmojiClickListener onEmojiClickListener) {
        this.clickListener = onEmojiClickListener;
    }

    @Nullable
    public final OnEmojiLongClickListener getLongClickListener$emoji_release() {
        return this.longClickListener;
    }

    public final void setLongClickListener$emoji_release(@Nullable OnEmojiLongClickListener onEmojiLongClickListener) {
        this.longClickListener = onEmojiLongClickListener;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        this.setMeasuredDimension(measuredWidth, measuredWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.variantIndicatorTop.x = w;
        this.variantIndicatorTop.y = h / 6 * 5;
        this.variantIndicatorBottomRight.x = w;
        this.variantIndicatorBottomRight.y = h;
        this.variantIndicatorBottomLeft.x = w / 6 * 5;
        this.variantIndicatorBottomLeft.y = h;
        this.variantIndicatorPath.rewind();
        this.variantIndicatorPath.moveTo((float)this.variantIndicatorTop.x, (float)this.variantIndicatorTop.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomRight.x, (float)this.variantIndicatorBottomRight.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomLeft.x, (float)this.variantIndicatorBottomLeft.y);
        this.variantIndicatorPath.close();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.hasVariants && this.getDrawable() != null) {
            canvas.drawPath(this.variantIndicatorPath, this.variantIndicatorPaint);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelFuture();
    }

    private final void cancelFuture() {
        ImageLoadingTask imageLoadingTask = this.imageLoadingTask;
        if (imageLoadingTask != null) {
            imageLoadingTask.cancel();
        }
        this.imageLoadingTask = null;
    }

    public final void setEmoji(@NotNull EmojiTheming theming, @NotNull Emoji emoji, @NotNull VariantEmoji variantEmoji) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
            this.variantIndicatorPaint.setColor(theming.dividerColor);
            this.postInvalidate();
            Emoji variant = variantEmoji.getVariant(emoji);
            if (Intrinsics.areEqual((Object)variant, (Object)this.currentEmoji)) break block1;
            this.setContentDescription(variant.getUnicode());
            this.setImageDrawable(null);
            this.currentEmoji = variant;
            List<Emoji> variants = variantEmoji.getVariants(emoji);
            this.hasVariants = !((Collection)variants).isEmpty();
            this.cancelFuture();
            this.setOnClickListener(arg_0 -> EmojiImageView.setEmoji$lambda$1(this, arg_0));
            this.setOnLongClickListener(this.hasVariants ? arg_0 -> EmojiImageView.setEmoji$lambda$2(this, emoji, variants, arg_0) : null);
            ImageLoadingTask imageLoadingTask = this.imageLoadingTask = new ImageLoadingTask((ImageView)this);
            if (imageLoadingTask != null) {
                imageLoadingTask.start(variant);
            }
        }
    }

    public final void updateEmoji(@NotNull Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        if (!Intrinsics.areEqual((Object)emoji, (Object)this.currentEmoji)) {
            this.currentEmoji = emoji;
            this.setContentDescription(emoji.getUnicode());
            EmojiAndroidProvider emojiAndroidProvider = UtilsKt.emojiDrawableProvider(EmojiManager.INSTANCE);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.setImageDrawable(emojiAndroidProvider.getDrawable(emoji, context));
        }
    }

    @JvmOverloads
    public EmojiImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void setEmoji$lambda$1(EmojiImageView this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            OnEmojiClickListener onEmojiClickListener = this$0.clickListener;
            if (onEmojiClickListener == null) break block0;
            Emoji emoji = this$0.currentEmoji;
            Intrinsics.checkNotNull((Object)emoji);
            onEmojiClickListener.onEmojiClick(emoji);
        }
    }

    private static final boolean setEmoji$lambda$2(EmojiImageView this$0, Emoji $emoji, List $variants, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$emoji, (String)"$emoji");
            Intrinsics.checkNotNullParameter((Object)$variants, (String)"$variants");
            OnEmojiLongClickListener onEmojiLongClickListener = this$0.longClickListener;
            if (onEmojiLongClickListener == null) break block0;
            onEmojiLongClickListener.onEmojiLongClick(this$0, $emoji, $variants);
        }
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vanniktech/emoji/internal/EmojiImageView$Companion;", "", "<init>", "()V", "VARIANT_INDICATOR_PART_AMOUNT", "", "VARIANT_INDICATOR_PART", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

