/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiAndroidProvider;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiEditTexts;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.internal.EmojiImageView;
import com.vanniktech.emoji.internal.EmojiPagerAdapter;
import com.vanniktech.emoji.internal.EmojiPagerDelegate;
import com.vanniktech.emoji.internal.EmojiSearchDialog;
import com.vanniktech.emoji.internal.EmojiSearchDialogDelegate;
import com.vanniktech.emoji.internal.EmojiVariantPopup;
import com.vanniktech.emoji.internal.RepeatListener;
import com.vanniktech.emoji.internal.UtilsKt;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.recent.RecentEmoji;
import com.vanniktech.emoji.recent.RecentEmojiManager;
import com.vanniktech.emoji.search.NoSearchEmoji;
import com.vanniktech.emoji.search.SearchEmoji;
import com.vanniktech.emoji.search.SearchEmojiManager;
import com.vanniktech.emoji.variant.VariantEmoji;
import com.vanniktech.emoji.variant.VariantEmojiManager;
import com.vanniktech.ui.AndroidViewKt;
import com.vanniktech.ui.Color;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Jb\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0015\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J*\u0010,\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u001f\u00102\u001a\u00020!2\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\u0006\u00108\u001a\u00020!J\b\u00109\u001a\u00020!H\u0002R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/vanniktech/emoji/EmojiView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "emojiTabs", "", "Landroid/widget/ImageButton;", "[Landroid/widget/ImageButton;", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "emojiPagerAdapter", "Lcom/vanniktech/emoji/internal/EmojiPagerAdapter;", "editText", "Landroid/widget/EditText;", "onEmojiClickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "onEmojiBackspaceClickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiBackspaceClickListener;", "emojiTabLastSelectedIndex", "", "variantPopup", "Lcom/vanniktech/emoji/internal/EmojiVariantPopup;", "recentEmoji", "Lcom/vanniktech/emoji/recent/RecentEmoji;", "searchEmoji", "Lcom/vanniktech/emoji/search/SearchEmoji;", "variantEmoji", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "setUp", "", "rootView", "Landroid/view/View;", "pageTransformer", "Landroidx/viewpager/widget/ViewPager$PageTransformer;", "selectPage", "index", "selectPage$emoji_release", "handleEmojiTabs", "emojisPager", "Landroidx/viewpager/widget/ViewPager;", "inflateButton", "icon", "categoryName", "", "parent", "Landroid/view/ViewGroup;", "handleEmojiClick", "emoji", "Lcom/vanniktech/emoji/Emoji;", "addWhitespace", "", "handleEmojiClick$emoji_release", "tearDown", "dismissVariantPopup", "EmojiTabsClickListener", "Companion", "emoji_release"})
public final class EmojiView
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImageButton[] emojiTabs;
    private EmojiTheming theming;
    private EmojiPagerAdapter emojiPagerAdapter;
    @Nullable
    private EditText editText;
    @Nullable
    private OnEmojiClickListener onEmojiClickListener;
    @Nullable
    private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    private int emojiTabLastSelectedIndex;
    private EmojiVariantPopup variantPopup;
    private RecentEmoji recentEmoji;
    private SearchEmoji searchEmoji;
    private VariantEmoji variantEmoji;
    private static final long INITIAL_INTERVAL = TimeUnit.SECONDS.toMillis(1L) / (long)2;
    private static final int NORMAL_INTERVAL = 50;

    @JvmOverloads
    public EmojiView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.emojiTabs = new ImageButton[0];
        this.emojiTabLastSelectedIndex = -1;
        LinearLayout.inflate((Context)context, (int)R.layout.emoji_view, (ViewGroup)((ViewGroup)this));
        this.setOrientation(1);
    }

    public /* synthetic */ EmojiView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        Context context = this.getContext();
        this.editText = editText;
        this.theming = theming;
        this.recentEmoji = recentEmoji;
        this.searchEmoji = searchEmoji;
        this.variantEmoji = variantEmoji;
        this.onEmojiBackspaceClickListener = onEmojiBackspaceClickListener;
        this.onEmojiClickListener = onEmojiClickListener;
        this.variantPopup = new EmojiVariantPopup(rootView, (arg_0, arg_1) -> EmojiView.setUp$lambda$0(this, arg_0, arg_1));
        this.setBackgroundColor(theming.backgroundColor);
        View view = this.findViewById(R.id.emojiViewPager);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        ViewPager emojisPager = (ViewPager)view;
        AndroidViewKt.themeViewPager-xAbW3D8((ViewPager)emojisPager, (int)Color.constructor-impl((int)theming.secondaryColor));
        View emojiDivider = this.findViewById(R.id.emojiViewDivider);
        emojiDivider.setBackgroundColor(theming.dividerColor);
        if (pageTransformer != null) {
            emojisPager.setPageTransformer(true, pageTransformer);
        }
        emojisPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ EmojiView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageScrollStateChanged(int position) {
            }

            public void onPageSelected(int position) {
                this.this$0.selectPage$emoji_release(position);
            }
        });
        Intrinsics.checkNotNull((Object)context);
        this.handleEmojiTabs(context, emojisPager);
        EmojiPagerAdapter emojiPagerAdapter = this.emojiPagerAdapter;
        if (emojiPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
            emojiPagerAdapter = null;
        }
        emojisPager.setAdapter((PagerAdapter)emojiPagerAdapter);
        EmojiPagerAdapter emojiPagerAdapter2 = this.emojiPagerAdapter;
        if (emojiPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
            emojiPagerAdapter2 = null;
        }
        if (emojiPagerAdapter2.hasRecentEmoji()) {
            EmojiPagerAdapter emojiPagerAdapter3 = this.emojiPagerAdapter;
            if (emojiPagerAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
                emojiPagerAdapter3 = null;
            }
            n = emojiPagerAdapter3.numberOfRecentEmojis() > 0 ? 0 : 1;
        } else {
            n = 0;
        }
        int startIndex = n;
        emojisPager.setCurrentItem(startIndex);
        this.selectPage$emoji_release(startIndex);
    }

    public static /* synthetic */ void setUp$default(EmojiView emojiView, View view, OnEmojiClickListener onEmojiClickListener, OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, EditText editText, EmojiTheming emojiTheming, RecentEmoji recentEmoji, SearchEmoji searchEmoji, VariantEmoji variantEmoji, ViewPager.PageTransformer pageTransformer, int n, Object object) {
        if ((n & 0x10) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            emojiTheming = EmojiTheming.Companion.from(context);
        }
        if ((n & 0x20) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            recentEmoji = new RecentEmojiManager(context, 0, 2, null);
        }
        if ((n & 0x40) != 0) {
            searchEmoji = new SearchEmojiManager();
        }
        if ((n & 0x80) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            variantEmoji = new VariantEmojiManager(context);
        }
        if ((n & 0x100) != 0) {
            pageTransformer = null;
        }
        emojiView.setUp(view, onEmojiClickListener, onEmojiBackspaceClickListener, editText, emojiTheming, recentEmoji, searchEmoji, variantEmoji, pageTransformer);
    }

    public final void selectPage$emoji_release(int index) {
        if (this.emojiTabLastSelectedIndex != index) {
            if (index == 0) {
                EmojiPagerAdapter emojiPagerAdapter = this.emojiPagerAdapter;
                if (emojiPagerAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
                    emojiPagerAdapter = null;
                }
                emojiPagerAdapter.invalidateRecentEmojis();
            }
            if (this.emojiTabLastSelectedIndex >= 0 && this.emojiTabLastSelectedIndex < this.emojiTabs.length) {
                ImageButton imageButton = this.emojiTabs[this.emojiTabLastSelectedIndex];
                Intrinsics.checkNotNull((Object)imageButton);
                imageButton.setSelected(false);
                ImageButton imageButton2 = this.emojiTabs[this.emojiTabLastSelectedIndex];
                Intrinsics.checkNotNull((Object)imageButton2);
                EmojiTheming emojiTheming = this.theming;
                if (emojiTheming == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"theming");
                    emojiTheming = null;
                }
                imageButton2.setColorFilter(emojiTheming.primaryColor, PorterDuff.Mode.SRC_IN);
            }
            ImageButton imageButton = this.emojiTabs[index];
            if (imageButton != null) {
                imageButton.setSelected(true);
            }
            ImageButton imageButton3 = this.emojiTabs[index];
            if (imageButton3 != null) {
                EmojiTheming emojiTheming = this.theming;
                if (emojiTheming == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"theming");
                    emojiTheming = null;
                }
                imageButton3.setColorFilter(emojiTheming.secondaryColor, PorterDuff.Mode.SRC_IN);
            }
            this.emojiTabLastSelectedIndex = index;
        }
    }

    private final void handleEmojiTabs(Context context, ViewPager emojisPager) {
        EmojiTheming emojiTheming;
        VariantEmoji variantEmoji;
        EmojiCategory[] categories = EmojiManager.INSTANCE.categories$emoji_release();
        LinearLayout emojisTab = (LinearLayout)this.findViewById(R.id.emojiViewTab);
        EmojiPagerDelegate emojiPagerDelegate = new EmojiPagerDelegate(this){
            final /* synthetic */ EmojiView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEmojiClick(Emoji emoji) {
                Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
                EmojiView.handleEmojiClick$emoji_release$default(this.this$0, emoji, false, 2, null);
            }

            public void onEmojiLongClick(EmojiImageView view, Emoji emoji, List<? extends Emoji> variants) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
                Intrinsics.checkNotNullParameter(variants, (String)"variants");
                EmojiVariantPopup emojiVariantPopup = EmojiView.access$getVariantPopup$p(this.this$0);
                if (emojiVariantPopup == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"variantPopup");
                    emojiVariantPopup = null;
                }
                emojiVariantPopup.show(view, emoji, variants);
            }
        };
        RecentEmoji recentEmoji = this.recentEmoji;
        if (recentEmoji == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recentEmoji");
            recentEmoji = null;
        }
        if ((variantEmoji = this.variantEmoji) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantEmoji");
            variantEmoji = null;
        }
        if ((emojiTheming = this.theming) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"theming");
            emojiTheming = null;
        }
        this.emojiPagerAdapter = new EmojiPagerAdapter(emojiPagerDelegate, recentEmoji, variantEmoji, emojiTheming);
        boolean hasBackspace = this.editText != null || this.onEmojiBackspaceClickListener != null;
        SearchEmoji searchEmoji = this.searchEmoji;
        if (searchEmoji == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchEmoji");
            searchEmoji = null;
        }
        boolean hasSearch = !(searchEmoji instanceof NoSearchEmoji);
        int endIndexes = (hasSearch ? 1 : 0) + (hasBackspace ? 1 : 0);
        EmojiPagerAdapter emojiPagerAdapter = this.emojiPagerAdapter;
        if (emojiPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
            emojiPagerAdapter = null;
        }
        int recentAdapterItemCount = emojiPagerAdapter.recentAdapterItemCount();
        this.emojiTabs = new ImageButton[recentAdapterItemCount + categories.length + endIndexes];
        EmojiPagerAdapter emojiPagerAdapter2 = this.emojiPagerAdapter;
        if (emojiPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
            emojiPagerAdapter2 = null;
        }
        if (emojiPagerAdapter2.hasRecentEmoji()) {
            String string2 = context.getString(R.string.emoji_category_recent);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            Intrinsics.checkNotNull((Object)emojisTab);
            this.emojiTabs[0] = this.inflateButton(context, R.drawable.emoji_recent, string2, (ViewGroup)emojisTab);
        }
        Integer searchIndex = hasSearch ? Integer.valueOf(this.emojiTabs.length - (hasBackspace ? 2 : 1)) : null;
        Integer backspaceIndex = hasBackspace ? Integer.valueOf(this.emojiTabs.length - 1) : null;
        String string3 = context.getString(R.string.emoji_language_code);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String languageCode = string3;
        EmojiAndroidProvider emojiDrawableProvider = UtilsKt.emojiDrawableProvider(EmojiManager.INSTANCE);
        for (EmojiCategory emojiCategory : categories) {
            String string4 = emojiCategory.getCategoryNames().get(languageCode);
            if (string4 == null) {
                string4 = "";
            }
            String categoryName = string4;
            int categoryIcon = emojiDrawableProvider.getIcon(emojiCategory);
            Intrinsics.checkNotNull((Object)emojisTab);
            this.emojiTabs[i + recentAdapterItemCount] = this.inflateButton(context, categoryIcon, categoryName, (ViewGroup)emojisTab);
        }
        if (searchIndex != null) {
            int n = searchIndex;
            String string5 = context.getString(R.string.emoji_search);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            Intrinsics.checkNotNull((Object)emojisTab);
            this.emojiTabs[n] = this.inflateButton(context, R.drawable.emoji_search, string5, (ViewGroup)emojisTab);
            ImageButton imageButton = this.emojiTabs[searchIndex];
            Intrinsics.checkNotNull((Object)imageButton);
            imageButton.setOnClickListener(arg_0 -> EmojiView.handleEmojiTabs$lambda$2(this, arg_0));
        }
        if (backspaceIndex != null) {
            int n = backspaceIndex;
            String string6 = context.getString(R.string.emoji_backspace);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
            Intrinsics.checkNotNull((Object)emojisTab);
            this.emojiTabs[n] = this.inflateButton(context, R.drawable.emoji_backspace, string6, (ViewGroup)emojisTab);
            ImageButton imageButton = this.emojiTabs[backspaceIndex];
            if (imageButton != null) {
                imageButton.setOnTouchListener((View.OnTouchListener)new RepeatListener(INITIAL_INTERVAL, 50L, arg_0 -> EmojiView.handleEmojiTabs$lambda$3(this, arg_0)));
            }
        }
        int n = this.emojiTabs.length - endIndexes;
        for (int i = 0; i < n; ++i) {
            ImageButton imageButton = this.emojiTabs[i];
            if (imageButton == null) continue;
            imageButton.setOnClickListener((View.OnClickListener)new EmojiTabsClickListener(emojisPager, i));
        }
    }

    private final ImageButton inflateButton(Context context, @DrawableRes int icon, String categoryName, ViewGroup parent) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.emoji_view_category, parent, false);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.ImageButton");
        ImageButton button = (ImageButton)view;
        button.setImageDrawable(AppCompatResources.getDrawable((Context)context, (int)icon));
        EmojiTheming emojiTheming = this.theming;
        if (emojiTheming == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"theming");
            emojiTheming = null;
        }
        button.setColorFilter(emojiTheming.primaryColor, PorterDuff.Mode.SRC_IN);
        button.setContentDescription((CharSequence)categoryName);
        parent.addView((View)button);
        return button;
    }

    public final void handleEmojiClick$emoji_release(@NotNull Emoji emoji, boolean addWhitespace) {
        block3: {
            RecentEmoji recentEmoji;
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            EditText editText = this.editText;
            if (editText != null) {
                EmojiEditTexts.input(editText, emoji, addWhitespace);
            }
            if ((recentEmoji = this.recentEmoji) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recentEmoji");
                recentEmoji = null;
            }
            recentEmoji.addEmoji(emoji);
            VariantEmoji variantEmoji = this.variantEmoji;
            if (variantEmoji == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"variantEmoji");
                variantEmoji = null;
            }
            variantEmoji.addVariant(emoji);
            OnEmojiClickListener onEmojiClickListener = this.onEmojiClickListener;
            if (onEmojiClickListener == null) break block3;
            onEmojiClickListener.onEmojiClick(emoji);
        }
    }

    public static /* synthetic */ void handleEmojiClick$emoji_release$default(EmojiView emojiView, Emoji emoji, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        emojiView.handleEmojiClick$emoji_release(emoji, bl);
    }

    public final void tearDown() {
        this.dismissVariantPopup();
        Executors.newSingleThreadExecutor().submit(() -> EmojiView.tearDown$lambda$4(this));
    }

    private final void dismissVariantPopup() {
        EmojiVariantPopup emojiVariantPopup = this.variantPopup;
        if (emojiVariantPopup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantPopup");
            emojiVariantPopup = null;
        }
        emojiVariantPopup.dismiss();
    }

    @JvmOverloads
    public EmojiView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        EmojiView.setUp$default(this, rootView, onEmojiClickListener, onEmojiBackspaceClickListener, editText, theming, recentEmoji, searchEmoji, variantEmoji, null, 256, null);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        EmojiView.setUp$default(this, rootView, onEmojiClickListener, onEmojiBackspaceClickListener, editText, theming, recentEmoji, searchEmoji, null, null, 384, null);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        EmojiView.setUp$default(this, rootView, onEmojiClickListener, onEmojiBackspaceClickListener, editText, theming, recentEmoji, null, null, null, 448, null);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText, @NotNull EmojiTheming theming) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        EmojiView.setUp$default(this, rootView, onEmojiClickListener, onEmojiBackspaceClickListener, editText, theming, null, null, null, null, 480, null);
    }

    @JvmOverloads
    public final void setUp(@NotNull View rootView, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable EditText editText) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        EmojiView.setUp$default(this, rootView, onEmojiClickListener, onEmojiBackspaceClickListener, editText, null, null, null, null, null, 496, null);
    }

    private static final void setUp$lambda$0(EmojiView this$0, EmojiImageView emojiImageView, Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)emojiImageView), (String)"emojiImageView");
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        EmojiView.handleEmojiClick$emoji_release$default(this$0, emoji, false, 2, null);
        emojiImageView.updateEmoji(emoji);
        this$0.dismissVariantPopup();
    }

    private static final void handleEmojiTabs$lambda$2$lambda$1(EmojiView this$0, Emoji it) {
        EmojiPagerAdapter emojiPagerAdapter;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleEmojiClick$emoji_release(it, true);
        EditText editText = this$0.editText;
        if (editText != null) {
            UtilsKt.showKeyboardAndFocus(editText);
        }
        if ((emojiPagerAdapter = this$0.emojiPagerAdapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiPagerAdapter");
            emojiPagerAdapter = null;
        }
        emojiPagerAdapter.invalidateRecentEmojis();
    }

    private static final void handleEmojiTabs$lambda$2(EmojiView this$0, View it) {
        EmojiTheming emojiTheming;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        EditText editText = this$0.editText;
        if (editText != null) {
            UtilsKt.hideKeyboardAndFocus(editText);
        }
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        EmojiSearchDialogDelegate emojiSearchDialogDelegate = arg_0 -> EmojiView.handleEmojiTabs$lambda$2$lambda$1(this$0, arg_0);
        SearchEmoji searchEmoji = this$0.searchEmoji;
        if (searchEmoji == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchEmoji");
            searchEmoji = null;
        }
        if ((emojiTheming = this$0.theming) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"theming");
            emojiTheming = null;
        }
        EmojiSearchDialog.Companion.show(context, emojiSearchDialogDelegate, searchEmoji, emojiTheming);
    }

    private static final void handleEmojiTabs$lambda$3(EmojiView this$0, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            EditText editText = this$0.editText;
            if (editText != null) {
                EmojiEditTexts.backspace(editText);
            }
            OnEmojiBackspaceClickListener onEmojiBackspaceClickListener = this$0.onEmojiBackspaceClickListener;
            if (onEmojiBackspaceClickListener == null) break block1;
            onEmojiBackspaceClickListener.onEmojiBackspaceClick();
        }
    }

    private static final void tearDown$lambda$4(EmojiView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RecentEmoji recentEmoji = this$0.recentEmoji;
        if (recentEmoji == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recentEmoji");
            recentEmoji = null;
        }
        recentEmoji.persist();
        VariantEmoji variantEmoji = this$0.variantEmoji;
        if (variantEmoji == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantEmoji");
            variantEmoji = null;
        }
        variantEmoji.persist();
    }

    public static final /* synthetic */ EmojiVariantPopup access$getVariantPopup$p(EmojiView $this) {
        return $this.variantPopup;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vanniktech/emoji/EmojiView$Companion;", "", "<init>", "()V", "INITIAL_INTERVAL", "", "NORMAL_INTERVAL", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/vanniktech/emoji/EmojiView$EmojiTabsClickListener;", "Landroid/view/View$OnClickListener;", "emojisPager", "Landroidx/viewpager/widget/ViewPager;", "position", "", "<init>", "(Landroidx/viewpager/widget/ViewPager;I)V", "onClick", "", "v", "Landroid/view/View;", "emoji_release"})
    public static final class EmojiTabsClickListener
    implements View.OnClickListener {
        @NotNull
        private final ViewPager emojisPager;
        private final int position;

        public EmojiTabsClickListener(@NotNull ViewPager emojisPager, int position) {
            Intrinsics.checkNotNullParameter((Object)emojisPager, (String)"emojisPager");
            this.emojisPager = emojisPager;
            this.position = position;
        }

        public void onClick(@NotNull View v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.emojisPager.setCurrentItem(this.position);
        }
    }
}

