/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.DisplayMetrics;
import com.canhub.cropper.BitmapUtils;
import com.canhub.cropper.CropImageView;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00050\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/canhub/cropper/BitmapLoadingWorkerJob;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "cropImageView", "Lcom/canhub/cropper/CropImageView;", "uri", "Landroid/net/Uri;", "<init>", "(Landroid/content/Context;Lcom/canhub/cropper/CropImageView;Landroid/net/Uri;)V", "getUri$cropper_release", "()Landroid/net/Uri;", "width", "", "height", "cropImageViewReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "job", "Lkotlinx/coroutines/Job;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "start", "", "onPostExecute", "result", "Lcom/canhub/cropper/BitmapLoadingWorkerJob$Result;", "(Lcom/canhub/cropper/BitmapLoadingWorkerJob$Result;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancel", "Result", "cropper_release"})
public final class BitmapLoadingWorkerJob
implements CoroutineScope {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri uri;
    private final int width;
    private final int height;
    @NotNull
    private final WeakReference<CropImageView> cropImageViewReference;
    @NotNull
    private Job job;

    public BitmapLoadingWorkerJob(@NotNull Context context, @NotNull CropImageView cropImageView, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cropImageView, (String)"cropImageView");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.context = context;
        this.uri = uri;
        this.cropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.job = (Job)JobKt.Job$default(null, (int)1, null);
        DisplayMetrics metrics = cropImageView.getResources().getDisplayMetrics();
        double densityAdjustment = metrics.density > 1.0f ? 1.0 / (double)metrics.density : 1.0;
        this.width = (int)((double)metrics.widthPixels * densityAdjustment);
        this.height = (int)((double)metrics.heightPixels * densityAdjustment);
    }

    @NotNull
    public final Uri getUri$cropper_release() {
        return this.uri;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return Dispatchers.getMain().plus((CoroutineContext)this.job);
    }

    public final void start() {
        this.job = BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BitmapLoadingWorkerJob this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) return Unit.INSTANCE;
                        BitmapUtils.BitmapSampled decodeResult = BitmapUtils.INSTANCE.decodeSampledBitmap(BitmapLoadingWorkerJob.access$getContext$p(this.this$0), this.this$0.getUri$cropper_release(), BitmapLoadingWorkerJob.access$getWidth$p(this.this$0), BitmapLoadingWorkerJob.access$getHeight$p(this.this$0));
                        if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) return Unit.INSTANCE;
                        BitmapUtils.RotateBitmapResult orientateResult = BitmapUtils.INSTANCE.orientateBitmapByExif(decodeResult.getBitmap(), BitmapLoadingWorkerJob.access$getContext$p(this.this$0), this.this$0.getUri$cropper_release());
                        this.label = 1;
                        Object object3 = BitmapLoadingWorkerJob.access$onPostExecute(this.this$0, new Result(this.this$0.getUri$cropper_release(), orientateResult.getBitmap(), decodeResult.getSampleSize(), orientateResult.getDegrees(), orientateResult.getFlipHorizontally(), orientateResult.getFlipVertically(), null), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        void $result;
                        Object object3;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            void var3_5;
                            this.label = 2;
                            object4 = BitmapLoadingWorkerJob.access$onPostExecute(this.this$0, new Result(this.this$0.getUri$cropper_release(), null, 0, 0, false, false, (Exception)var3_5), (Continuation)this);
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                    }
                    case 2: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Object onPostExecute(Result result, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BitmapLoadingWorkerJob this$0;
            final /* synthetic */ Result $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                        Ref.BooleanRef completeCalled = new Ref.BooleanRef();
                        if (CoroutineScopeKt.isActive((CoroutineScope)$this$withContext)) {
                            CropImageView cropImageView = (CropImageView)BitmapLoadingWorkerJob.access$getCropImageViewReference$p(this.this$0).get();
                            if (cropImageView != null) {
                                CropImageView cropImageView2 = cropImageView;
                                Result result = this.$result;
                                CropImageView it = cropImageView2;
                                boolean bl = false;
                                completeCalled.element = true;
                                it.onSetImageUriAsyncComplete$cropper_release(result);
                            }
                        }
                        if (!completeCalled.element && this.$result.getBitmap() != null) {
                            this.$result.getBitmap().recycle();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void cancel() {
        Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
    }

    public static final /* synthetic */ Context access$getContext$p(BitmapLoadingWorkerJob $this) {
        return $this.context;
    }

    public static final /* synthetic */ int access$getWidth$p(BitmapLoadingWorkerJob $this) {
        return $this.width;
    }

    public static final /* synthetic */ int access$getHeight$p(BitmapLoadingWorkerJob $this) {
        return $this.height;
    }

    public static final /* synthetic */ Object access$onPostExecute(BitmapLoadingWorkerJob $this, Result result, Continuation $completion) {
        return $this.onPostExecute(result, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ WeakReference access$getCropImageViewReference$p(BitmapLoadingWorkerJob $this) {
        return $this.cropImageViewReference;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\u0016\u0010$\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ^\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0010\b\u0002\u0010\f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\rH\u00c6\u0001\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001b\u0010\f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\r\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/canhub/cropper/BitmapLoadingWorkerJob$Result;", "", "uri", "Landroid/net/Uri;", "bitmap", "Landroid/graphics/Bitmap;", "loadSampleSize", "", "degreesRotated", "flipHorizontally", "", "flipVertically", "error", "Lkotlin/Exception;", "Ljava/lang/Exception;", "<init>", "(Landroid/net/Uri;Landroid/graphics/Bitmap;IIZZLjava/lang/Exception;)V", "getUri", "()Landroid/net/Uri;", "getBitmap", "()Landroid/graphics/Bitmap;", "getLoadSampleSize", "()I", "getDegreesRotated", "getFlipHorizontally", "()Z", "getFlipVertically", "getError", "()Ljava/lang/Exception;", "Ljava/lang/Exception;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Landroid/net/Uri;Landroid/graphics/Bitmap;IIZZLjava/lang/Exception;)Lcom/canhub/cropper/BitmapLoadingWorkerJob$Result;", "equals", "other", "hashCode", "toString", "", "cropper_release"})
    public static final class Result {
        @NotNull
        private final Uri uri;
        @Nullable
        private final Bitmap bitmap;
        private final int loadSampleSize;
        private final int degreesRotated;
        private final boolean flipHorizontally;
        private final boolean flipVertically;
        @Nullable
        private final Exception error;

        public Result(@NotNull Uri uri, @Nullable Bitmap bitmap, int loadSampleSize, int degreesRotated, boolean flipHorizontally, boolean flipVertically, @Nullable Exception error) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            this.bitmap = bitmap;
            this.loadSampleSize = loadSampleSize;
            this.degreesRotated = degreesRotated;
            this.flipHorizontally = flipHorizontally;
            this.flipVertically = flipVertically;
            this.error = error;
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final int getLoadSampleSize() {
            return this.loadSampleSize;
        }

        public final int getDegreesRotated() {
            return this.degreesRotated;
        }

        public final boolean getFlipHorizontally() {
            return this.flipHorizontally;
        }

        public final boolean getFlipVertically() {
            return this.flipVertically;
        }

        @Nullable
        public final Exception getError() {
            return this.error;
        }

        @NotNull
        public final Uri component1() {
            return this.uri;
        }

        @Nullable
        public final Bitmap component2() {
            return this.bitmap;
        }

        public final int component3() {
            return this.loadSampleSize;
        }

        public final int component4() {
            return this.degreesRotated;
        }

        public final boolean component5() {
            return this.flipHorizontally;
        }

        public final boolean component6() {
            return this.flipVertically;
        }

        @Nullable
        public final Exception component7() {
            return this.error;
        }

        @NotNull
        public final Result copy(@NotNull Uri uri, @Nullable Bitmap bitmap, int loadSampleSize, int degreesRotated, boolean flipHorizontally, boolean flipVertically, @Nullable Exception error) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return new Result(uri, bitmap, loadSampleSize, degreesRotated, flipHorizontally, flipVertically, error);
        }

        public static /* synthetic */ Result copy$default(Result result, Uri uri, Bitmap bitmap, int n, int n2, boolean bl, boolean bl2, Exception exception, int n3, Object object) {
            if ((n3 & 1) != 0) {
                uri = result.uri;
            }
            if ((n3 & 2) != 0) {
                bitmap = result.bitmap;
            }
            if ((n3 & 4) != 0) {
                n = result.loadSampleSize;
            }
            if ((n3 & 8) != 0) {
                n2 = result.degreesRotated;
            }
            if ((n3 & 0x10) != 0) {
                bl = result.flipHorizontally;
            }
            if ((n3 & 0x20) != 0) {
                bl2 = result.flipVertically;
            }
            if ((n3 & 0x40) != 0) {
                exception = result.error;
            }
            return result.copy(uri, bitmap, n, n2, bl, bl2, exception);
        }

        @NotNull
        public String toString() {
            return "Result(uri=" + this.uri + ", bitmap=" + this.bitmap + ", loadSampleSize=" + this.loadSampleSize + ", degreesRotated=" + this.degreesRotated + ", flipHorizontally=" + this.flipHorizontally + ", flipVertically=" + this.flipVertically + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = result * 31 + (this.bitmap == null ? 0 : this.bitmap.hashCode());
            result = result * 31 + Integer.hashCode(this.loadSampleSize);
            result = result * 31 + Integer.hashCode(this.degreesRotated);
            result = result * 31 + Boolean.hashCode(this.flipHorizontally);
            result = result * 31 + Boolean.hashCode(this.flipVertically);
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.uri, (Object)result.uri)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bitmap, (Object)result.bitmap)) {
                return false;
            }
            if (this.loadSampleSize != result.loadSampleSize) {
                return false;
            }
            if (this.degreesRotated != result.degreesRotated) {
                return false;
            }
            if (this.flipHorizontally != result.flipHorizontally) {
                return false;
            }
            if (this.flipVertically != result.flipVertically) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)result.error);
        }
    }
}

