/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import com.vaadin.testbench.parallel.BrowserUtil;
import java.io.File;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.safari.SafariDriver;

@Element(value="vaadin-upload")
public class UploadElement
extends TestBenchElement {
    public void upload(File file) {
        this.upload(file, 60);
    }

    public void upload(File file, int maxSeconds) {
        if (this.isMaxFilesReached()) {
            this.removeFile(0);
        }
        TestBenchElement uploadElement = UploadElement.isLocalDriver(this.getDriver()) ? this.getUploadElement() : this.setLocalFileDetector();
        Boolean hidden = uploadElement.getPropertyBoolean(new String[]{"hidden"});
        uploadElement.setProperty("hidden", Boolean.valueOf(false));
        if (!BrowserUtil.isEdge((Capabilities)this.getCapabilities())) {
            uploadElement.clear();
        }
        uploadElement.sendKeys(new CharSequence[]{file.getPath()});
        uploadElement.setProperty("hidden", hidden);
        if (maxSeconds > 0) {
            this.waitForUploads(maxSeconds);
        }
    }

    public void uploadMultiple(List<File> files, int maxSeconds) {
        boolean originalNoAuto = this.getPropertyBoolean(new String[]{"noAuto"});
        this.setProperty("noAuto", true);
        files.forEach(file -> this.upload((File)file, 0));
        this.startUpload();
        if (maxSeconds > 0) {
            this.waitForUploads(maxSeconds);
        }
        this.setProperty("noAuto", originalNoAuto);
    }

    private void waitForUploads(int maxSeconds) {
        String script = "return arguments[0].files.every((file) => !file.uploading);";
        this.waitUntil(driver -> (Boolean)this.executeScript(script, new Object[]{this}), maxSeconds);
    }

    private void removeFile(int i) {
        this.executeScript("arguments[0]._removeFile(arguments[0].files[arguments[1]])", new Object[]{this, i});
    }

    private void startUpload() {
        this.executeScript("arguments[0].uploadFiles()", new Object[]{this});
    }

    public int getMaxFiles() {
        return this.getPropertyInteger(new String[]{"maxFiles"});
    }

    public boolean isMaxFilesReached() {
        return this.getPropertyBoolean(new String[]{"maxFilesReached"});
    }

    private TestBenchElement setLocalFileDetector() {
        TestBenchElement uploadElement;
        TestBenchElement realUploadElement = uploadElement = this.getUploadElement();
        while (realUploadElement instanceof WrapsElement) {
            realUploadElement = ((WrapsElement)realUploadElement).getWrappedElement();
        }
        if (!(realUploadElement instanceof RemoteWebElement)) {
            throw new IllegalArgumentException("Expected argument of type " + RemoteWebElement.class.getName() + ", received " + realUploadElement.getClass().getName());
        }
        ((RemoteWebElement)realUploadElement).setFileDetector((FileDetector)new LocalFileDetector());
        return uploadElement;
    }

    private TestBenchElement getUploadElement() {
        return this.getPropertyElement(new String[]{"$", "fileInput"});
    }

    public void abort() {
        this.executeScript("arguments[0].files.forEach(function(file) { return arguments[0].dispatchEvent(new CustomEvent('file-abort', {detail: {file: file}}));})", new Object[]{this});
    }

    private static boolean isLocalDriver(WebDriver driver) {
        while (driver instanceof WrapsDriver) {
            driver = ((WrapsDriver)driver).getWrappedDriver();
        }
        return driver instanceof ChromiumDriver || driver instanceof FirefoxDriver || driver instanceof SafariDriver;
    }
}

