/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.receivers;

import com.vaadin.flow.component.upload.MultiFileReceiver;
import com.vaadin.flow.component.upload.receivers.AbstractFileBuffer;
import com.vaadin.flow.component.upload.receivers.FileData;
import com.vaadin.flow.component.upload.receivers.FileFactory;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MultiFileBuffer
extends AbstractFileBuffer
implements MultiFileReceiver {
    private Map<String, FileData> files = new HashMap<String, FileData>();

    public MultiFileBuffer() {
    }

    public MultiFileBuffer(FileFactory factory) {
        super(factory);
    }

    @Override
    public OutputStream receiveUpload(String fileName, String mimeType) {
        FileOutputStream outputBuffer = this.createFileOutputStream(fileName);
        this.files.put(fileName, new FileData(fileName, mimeType, outputBuffer));
        return outputBuffer;
    }

    public Set<String> getFiles() {
        return this.files.keySet();
    }

    public FileData getFileData(String fileName) {
        return this.files.get(fileName);
    }

    public FileDescriptor getFileDescriptor(String fileName) {
        if (this.files.containsKey(fileName)) {
            try {
                return ((FileOutputStream)this.files.get(fileName).getOutputBuffer()).getFD();
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Failed to get file descriptor for: '" + fileName + "'", e);
            }
        }
        return null;
    }

    public InputStream getInputStream(String fileName) {
        if (this.files.containsKey(fileName)) {
            try {
                return new FileInputStream(this.files.get(fileName).getFile());
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Failed to create InputStream for: '" + fileName + "'", e);
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

