/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;

@Tag(value="vaadin-upload")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.2.18"), @NpmPackage(value="@vaadin/upload", version="23.2.18"), @NpmPackage(value="@vaadin/vaadin-upload", version="23.2.18")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/upload/src/vaadin-upload.js")})
public abstract class GeneratedVaadinUpload<R extends GeneratedVaadinUpload<R>>
extends Component
implements HasStyle {
    protected boolean isNodropBoolean() {
        return this.getElement().getProperty("nodrop", false);
    }

    protected void setNodrop(boolean nodrop) {
        this.getElement().setProperty("nodrop", nodrop);
    }

    protected String getTargetString() {
        return this.getElement().getProperty("target");
    }

    protected void setTarget(String target) {
        this.getElement().setProperty("target", target == null ? "" : target);
    }

    protected String getMethodString() {
        return this.getElement().getProperty("method");
    }

    protected void setMethod(String method) {
        this.getElement().setProperty("method", method == null ? "" : method);
    }

    protected JsonObject getHeadersJsonObject() {
        return (JsonObject)this.getElement().getPropertyRaw("headers");
    }

    protected void setHeaders(JsonObject headers) {
        this.getElement().setPropertyJson("headers", (JsonValue)headers);
    }

    protected double getTimeoutDouble() {
        return this.getElement().getProperty("timeout", 0.0);
    }

    protected void setTimeout(double timeout) {
        this.getElement().setProperty("timeout", timeout);
    }

    @Synchronize(property="files", value={"files-changed"})
    protected JsonArray getFilesJsonArray() {
        return (JsonArray)this.getElement().getPropertyRaw("files");
    }

    protected void setFiles(JsonArray files) {
        this.getElement().setPropertyJson("files", (JsonValue)files);
    }

    protected double getMaxFilesDouble() {
        return this.getElement().getProperty("maxFiles", 0.0);
    }

    protected void setMaxFiles(double maxFiles) {
        this.getElement().setProperty("maxFiles", maxFiles);
    }

    @Synchronize(property="maxFilesReached", value={"max-files-reached-changed"})
    protected boolean isMaxFilesReachedBoolean() {
        return this.getElement().getProperty("maxFilesReached", false);
    }

    protected String getAcceptString() {
        return this.getElement().getProperty("accept");
    }

    protected void setAccept(String accept) {
        this.getElement().setProperty("accept", accept == null ? "" : accept);
    }

    protected double getMaxFileSizeDouble() {
        return this.getElement().getProperty("maxFileSize", 0.0);
    }

    protected void setMaxFileSize(double maxFileSize) {
        this.getElement().setProperty("maxFileSize", maxFileSize);
    }

    protected String getFormDataNameString() {
        return this.getElement().getProperty("formDataName");
    }

    protected void setFormDataName(String formDataName) {
        this.getElement().setProperty("formDataName", formDataName == null ? "" : formDataName);
    }

    protected boolean isNoAutoBoolean() {
        return this.getElement().getProperty("noAuto", false);
    }

    protected void setNoAuto(boolean noAuto) {
        this.getElement().setProperty("noAuto", noAuto);
    }

    protected boolean isWithCredentialsBoolean() {
        return this.getElement().getProperty("withCredentials", false);
    }

    protected void setWithCredentials(boolean withCredentials) {
        this.getElement().setProperty("withCredentials", withCredentials);
    }

    protected String getCaptureString() {
        return this.getElement().getProperty("capture");
    }

    protected void setCapture(String capture) {
        this.getElement().setProperty("capture", capture == null ? "" : capture);
    }

    protected JsonObject getI18nJsonObject() {
        return (JsonObject)this.getElement().getPropertyRaw("i18n");
    }

    protected void setI18n(JsonObject i18n) {
        this.getElement().setPropertyJson("i18n", (JsonValue)i18n);
    }

    protected void uploadFiles(JsonObject files) {
        this.getElement().callJsFunction("uploadFiles", new Serializable[]{files});
    }

    protected Registration addFileRejectListener(ComponentEventListener<FileRejectEvent<R>> listener) {
        return this.addListener(FileRejectEvent.class, listener);
    }

    protected Registration addUploadAbortListener(ComponentEventListener<UploadAbortEvent<R>> listener) {
        return this.addListener(UploadAbortEvent.class, listener);
    }

    protected Registration addUploadBeforeListener(ComponentEventListener<UploadBeforeEvent<R>> listener) {
        return this.addListener(UploadBeforeEvent.class, listener);
    }

    protected Registration addUploadErrorListener(ComponentEventListener<UploadErrorEvent<R>> listener) {
        return this.addListener(UploadErrorEvent.class, listener);
    }

    protected Registration addUploadProgressListener(ComponentEventListener<UploadProgressEvent<R>> listener) {
        return this.addListener(UploadProgressEvent.class, listener);
    }

    protected Registration addUploadRequestListener(ComponentEventListener<UploadRequestEvent<R>> listener) {
        return this.addListener(UploadRequestEvent.class, listener);
    }

    protected Registration addUploadResponseListener(ComponentEventListener<UploadResponseEvent<R>> listener) {
        return this.addListener(UploadResponseEvent.class, listener);
    }

    protected Registration addUploadRetryListener(ComponentEventListener<UploadRetryEvent<R>> listener) {
        return this.addListener(UploadRetryEvent.class, listener);
    }

    protected Registration addUploadStartListener(ComponentEventListener<UploadStartEvent<R>> listener) {
        return this.addListener(UploadStartEvent.class, listener);
    }

    protected Registration addUploadSuccessListener(ComponentEventListener<UploadSuccessEvent<R>> listener) {
        return this.addListener(UploadSuccessEvent.class, listener);
    }

    protected Registration addFilesChangeListener(ComponentEventListener<FilesChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("files", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new FilesChangeEvent<GeneratedVaadinUpload>(this, event.isUserOriginated())));
    }

    protected Registration addMaxFilesReachedChangeListener(ComponentEventListener<MaxFilesReachedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("maxFilesReached", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new MaxFilesReachedChangeEvent<GeneratedVaadinUpload>(this, event.isUserOriginated())));
    }

    protected void addToAddButton(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "add-button");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToDropLabelIcon(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "drop-label-icon");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToDropLabel(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "drop-label");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToFileList(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "file-list");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public static class MaxFilesReachedChangeEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final boolean maxFilesReached;

        public MaxFilesReachedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.maxFilesReached = ((GeneratedVaadinUpload)((Object)source)).isMaxFilesReachedBoolean();
        }

        public boolean isMaxFilesReached() {
            return this.maxFilesReached;
        }
    }

    public static class FilesChangeEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonArray files;

        public FilesChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.files = ((GeneratedVaadinUpload)((Object)source)).getFilesJsonArray();
        }

        public JsonArray getFiles() {
            return this.files;
        }
    }

    @DomEvent(value="upload-success")
    public static class UploadSuccessEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadSuccessEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-start")
    public static class UploadStartEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadStartEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-retry")
    public static class UploadRetryEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadRetryEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-response")
    public static class UploadResponseEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadResponseEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-request")
    public static class UploadRequestEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;
        private final JsonObject detailFormData;

        public UploadRequestEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile, @EventData(value="event.detail.formData") JsonObject detailFormData) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
            this.detailFormData = detailFormData;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }

        public JsonObject getDetailFormData() {
            return this.detailFormData;
        }
    }

    @DomEvent(value="upload-progress")
    public static class UploadProgressEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadProgressEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-error")
    public static class UploadErrorEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadErrorEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="upload-before")
    public static class UploadBeforeEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;
        private final JsonObject detailFileUploadTarget;

        public UploadBeforeEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile, @EventData(value="event.detail.file.uploadTarget") JsonObject detailFileUploadTarget) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
            this.detailFileUploadTarget = detailFileUploadTarget;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }

        public JsonObject getDetailFileUploadTarget() {
            return this.detailFileUploadTarget;
        }
    }

    @DomEvent(value="upload-abort")
    public static class UploadAbortEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailXhr;
        private final JsonObject detailFile;

        public UploadAbortEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.xhr") JsonObject detailXhr, @EventData(value="event.detail.file") JsonObject detailFile) {
            super(source, fromClient);
            this.detail = detail;
            this.detailXhr = detailXhr;
            this.detailFile = detailFile;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailXhr() {
            return this.detailXhr;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }
    }

    @DomEvent(value="file-reject")
    public static class FileRejectEvent<R extends GeneratedVaadinUpload<R>>
    extends ComponentEvent<R> {
        private final JsonObject detail;
        private final JsonObject detailFile;
        private final String detailError;

        public FileRejectEvent(R source, boolean fromClient, @EventData(value="event.detail") JsonObject detail, @EventData(value="event.detail.file") JsonObject detailFile, @EventData(value="event.detail.error") String detailError) {
            super(source, fromClient);
            this.detail = detail;
            this.detailFile = detailFile;
            this.detailError = detailError;
        }

        public JsonObject getDetail() {
            return this.detail;
        }

        public JsonObject getDetailFile() {
            return this.detailFile;
        }

        public String getDetailError() {
            return this.detailError;
        }
    }
}

