/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.receivers;

import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.receivers.AbstractFileBuffer;
import com.vaadin.flow.component.upload.receivers.FileData;
import com.vaadin.flow.component.upload.receivers.FileFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public class FileBuffer
extends AbstractFileBuffer
implements Receiver {
    private FileData file;

    public FileBuffer() {
    }

    public FileBuffer(FileFactory factory) {
        super(factory);
    }

    @Override
    public OutputStream receiveUpload(String fileName, String mimeType) {
        FileOutputStream outputBuffer = this.createFileOutputStream(fileName);
        this.file = new FileData(fileName, mimeType, outputBuffer);
        return outputBuffer;
    }

    public FileData getFileData() {
        return this.file;
    }

    public String getFileName() {
        return this.file != null ? this.file.getFileName() : "";
    }

    public FileDescriptor getFileDescriptor() {
        if (this.file != null) {
            try {
                return ((FileOutputStream)this.file.getOutputBuffer()).getFD();
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Failed to get file descriptor for: '" + this.getFileName() + "'", e);
            }
        }
        return null;
    }

    public InputStream getInputStream() {
        if (this.file != null) {
            File path = this.file.getFile();
            try {
                return new FileInputStream(path);
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Failed to create InputStream for: '" + this.getFileName() + "'", e);
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

