/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.receivers;

import com.vaadin.flow.component.upload.receivers.FileFactory;
import com.vaadin.flow.component.upload.receivers.TemporaryFileFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFileBuffer
implements Serializable {
    private FileFactory factory;

    public AbstractFileBuffer() {
        this.factory = new TemporaryFileFactory();
    }

    public AbstractFileBuffer(FileFactory factory) {
        this.factory = factory;
    }

    protected FileOutputStream createFileOutputStream(String fileName) {
        try {
            return new FileOutputStream(this.factory.createFile(fileName));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to create temporary file output stream", e);
            return null;
        }
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }
}

