/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker.testbench;

import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.HasStringValueProperty;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

@Element(value="vaadin-time-picker")
public class TimePickerElement
extends TestBenchElement
implements HasStringValueProperty,
HasSelectByText {
    public TimePickerComboBoxLightElement getTimePickerComboBoxLightElement() {
        return (TimePickerComboBoxLightElement)this.$(TimePickerComboBoxLightElement.class).first();
    }

    public TimePickerTextFieldElement getTimePickerTextFieldElement() {
        return (TimePickerTextFieldElement)this.getTimePickerComboBoxLightElement().$(TimePickerTextFieldElement.class).first();
    }

    public String getText() {
        return this.getPropertyString(new String[]{"textContent"});
    }

    public String getItemText(int index) {
        return ((ComboBoxOverlayElement)this.$(ComboBoxOverlayElement.class).onPage().first()).getItem(index).getText();
    }

    public String getLastItemText() {
        return ((ComboBoxOverlayElement)this.$(ComboBoxOverlayElement.class).onPage().first()).getLastItem().getText();
    }

    public String getTimePickerTextFieldValue() {
        return this.getTimePickerTextFieldElement().getValue();
    }

    public void openDropDown() {
        this.executeScript("arguments[0].open()", new Object[]{this.getTimePickerComboBoxLightElement()});
        this.waitUntilDropDownOpen();
    }

    public void waitUntilDropDownOpen() {
        this.$(ComboBoxOverlayElement.class).onPage().waitForFirst();
    }

    public void closeDropDown() {
        this.executeScript("const cb = arguments[0]; window.requestAnimationFrame(function(){ cb.close(); });", new Object[]{this.getTimePickerComboBoxLightElement()});
        this.waitUntil(input -> input.findElements(By.tagName((String)"vaadin-combo-box-overlay")).isEmpty());
    }

    public void scrollToItem(int index) {
        this.executeScript("arguments[0].$.overlay._scrollIntoView(arguments[1])", new Object[]{this.getTimePickerComboBoxLightElement(), index});
    }

    public void selectItemByIndex(int index) {
        this.openDropDown();
        this.scrollToItem(index);
        TestBenchElement item = ((ComboBoxOverlayElement)this.$(ComboBoxOverlayElement.class).onPage().first()).getItem(index);
        item.click();
    }

    public void selectByText(String timeInput) {
        Objects.requireNonNull(timeInput, "null input not accepted");
        TimePickerTextFieldElement timePickerTextFieldElement = this.getTimePickerTextFieldElement();
        this.executeScript("arguments[0].value = ''", new Object[]{timePickerTextFieldElement});
        timePickerTextFieldElement.sendKeys(new CharSequence[]{timeInput + Keys.RETURN});
    }

    public String getSelectedText() {
        return this.getTimePickerTextFieldElement().getValue();
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    @Element(value="vaadin-combo-box-overlay")
    public static class ComboBoxOverlayElement
    extends TestBenchElement {
        public TestBenchElement getItem(int index) {
            return this.$(TestBenchElement.class).id("content").$(TestBenchElement.class).id("selector").$("vaadin-combo-box-item").get(index);
        }

        public TestBenchElement getLastItem() {
            return this.$(TestBenchElement.class).id("content").$(TestBenchElement.class).id("selector").$("vaadin-combo-box-item").last();
        }
    }

    @Element(value="vaadin-time-picker-text-field")
    public static class TimePickerTextFieldElement
    extends TestBenchElement
    implements HasStringValueProperty {
    }

    @Element(value="vaadin-combo-box-light")
    public static class TimePickerComboBoxLightElement
    extends TestBenchElement {
    }
}

