/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.testbench.unit.BaseUIUnitTest;
import com.vaadin.testbench.unit.ComponentQuery;
import com.vaadin.testbench.unit.internal.PrettyPrintTreeKt;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class ComponentTester<T extends Component> {
    private final T component;

    public ComponentTester(T component) {
        this.component = component;
        if (!this.isUsable()) {
            LoggerFactory.getLogger((String)"Test wrap").debug("Wrapped component '{}' that is not interactable", (Object)component.getClass().getSimpleName());
        }
    }

    public T getComponent() {
        return this.component;
    }

    public boolean isUsable() {
        T component = this.getComponent();
        return component.getElement().isEnabled() && component.isAttached() && this.isEffectivelyVisible((Component)component) && !component.getElement().getNode().isInert();
    }

    private boolean isEffectivelyVisible(Component component) {
        return component.isVisible() && (!component.getParent().isPresent() || this.isEffectivelyVisible((Component)component.getParent().get()));
    }

    public void setModal(boolean modal) {
        UI.getCurrent().setChildComponentModal(this.component, modal);
    }

    public <R extends Component> ComponentQuery<R> find(Class<R> componentType) {
        return BaseUIUnitTest.internalQuery(componentType).from((Component)this.component);
    }

    protected final void ensureComponentIsUsable() {
        if (!this.isUsable()) {
            StringBuilder message = new StringBuilder(PrettyPrintTreeKt.toPrettyString(this.component) + " is not usable");
            Stream.Builder reasons = Stream.builder();
            this.notUsableReasons(reasons::add);
            message.append(reasons.build().collect(Collectors.joining(", ", " because it is ", ".")));
            throw new IllegalStateException(message.toString());
        }
    }

    protected void notUsableReasons(Consumer<String> collector) {
        if (!this.component.getElement().isEnabled()) {
            collector.accept("not enabled");
        }
        if (!this.component.isAttached()) {
            collector.accept("not attached");
        }
        if (!this.component.isVisible()) {
            collector.accept("not visible");
        } else if (!this.isEffectivelyVisible((Component)this.component)) {
            collector.accept("part of a not visible subtree");
        }
        if (this.component.getElement().getNode().isInert()) {
            collector.accept("behind a modality curtain");
        }
    }

    protected void ensureVisible() {
        if (!this.getComponent().isVisible() || !this.getComponent().isAttached()) {
            throw new IllegalStateException(PrettyPrintTreeKt.toPrettyString(this.component) + " is not visible!");
        }
    }

    protected void roundTrip() {
        BaseUIUnitTest.roundTrip();
    }

    protected Field getField(String fieldName) {
        return this.getField(this.getComponent().getClass(), fieldName);
    }

    protected Field getField(Class target, String fieldName) {
        try {
            Field field = target.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Method getMethod(String methodName, Class<?> ... parameterTypes) {
        return this.getMethod(this.getComponent().getClass(), methodName, parameterTypes);
    }

    protected Method getMethod(Class target, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = target.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fireDomEvent(String eventType) {
        this.fireDomEvent(eventType, Json.createObject());
    }

    protected void fireDomEvent(String eventType, JsonObject eventData) {
        DomEvent event = new DomEvent(this.getComponent().getElement(), eventType, eventData);
        this.fireDomEvent(event);
    }

    protected void fireDomEvent(DomEvent event) {
        ((ElementListenerMap)event.getSource().getNode().getFeature(ElementListenerMap.class)).fireEvent(event);
    }

    protected <R extends Component> Optional<R> findByQuery(Class<R> componentType, Consumer<ComponentQuery<R>> queryBuilder) {
        List<R> result2 = this.findAllByQuery(componentType, queryBuilder);
        if (result2.isEmpty()) {
            return Optional.empty();
        }
        if (result2.size() > 1) {
            StringBuilder message = new StringBuilder("Expecting the query to produce at most one result, but got ").append(result2.size()).append(": ");
            message.append(result2.stream().map(PrettyPrintTreeKt::toPrettyString).collect(Collectors.joining(", ")));
            throw new IllegalArgumentException(message.toString());
        }
        return Optional.of((Component)result2.get(0));
    }

    protected <R extends Component> List<R> findAllByQuery(Class<R> componentType, Consumer<ComponentQuery<R>> queryBuilder) {
        ComponentQuery<R> query = BaseUIUnitTest.internalQuery(componentType).from((Component)this.component);
        queryBuilder.accept(query);
        query.from((Component)this.component);
        return query.all();
    }
}

