/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import com.vaadin.testbench.unit.internal.PrettyPrintTreeKt;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Tests(value={MenuBar.class})
public class MenuBarTester<T extends MenuBar>
extends ComponentTester<T> {
    public MenuBarTester(T component) {
        super(component);
    }

    public void clickItem(String topLevelText, String ... nestedItemsText) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelText, nestedItemsText);
        this.clickMenuItem(menuItem);
    }

    public void clickItem(int topLevelPosition, int ... nestedItemsPositions) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelPosition, nestedItemsPositions);
        this.clickMenuItem(menuItem);
    }

    public boolean isItemChecked(String topLevelText, String ... nestedItemsText) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelText, nestedItemsText);
        if (!menuItem.isCheckable()) {
            String fullPath = topLevelText + (String)(nestedItemsText.length > 0 ? " / " + String.join((CharSequence)" / ", nestedItemsText) : "");
            throw new IllegalArgumentException("Menu item at position " + fullPath + " is not a checkable menu item");
        }
        return menuItem.isChecked();
    }

    public boolean isItemChecked(int topLevelPosition, int ... nestedItemsPositions) {
        this.ensureComponentIsUsable();
        MenuItem menuItem = this.findMenuItemByPath(topLevelPosition, nestedItemsPositions);
        if (!menuItem.isCheckable()) {
            String fullPath = IntStream.concat(IntStream.of(topLevelPosition), IntStream.of(nestedItemsPositions)).mapToObj(Integer::toString).collect(Collectors.joining(" / "));
            throw new IllegalArgumentException("Menu item at position " + fullPath + " is not a checkable menu item");
        }
        return menuItem.isChecked();
    }

    private MenuItem findMenuItemByPath(String topLevelText, String ... nestedItemsText) {
        MenuItem menuItem = this.findMenuItem(((MenuBar)this.getComponent()).getItems(), topLevelText, null);
        if (nestedItemsText.length > 0) {
            String path = topLevelText + " / " + String.join((CharSequence)" / ", nestedItemsText);
            for (String text : nestedItemsText) {
                if (!menuItem.isParentItem()) {
                    throw new IllegalArgumentException("Menu item with text " + menuItem.getText() + " has no children. Make sure that the path is correct: " + path);
                }
                menuItem = this.findMenuItem(((SubMenu)menuItem.getSubMenu()).getItems(), text, path);
            }
        }
        return menuItem;
    }

    private MenuItem findMenuItem(List<MenuItem> allItems, String text, String fullPath) {
        List items = allItems.stream().filter(item -> text.equals(item.getText())).collect(Collectors.toList());
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot find menu item with text " + text + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        if (items.size() > 1) {
            throw new IllegalStateException("Expecting a single menu item with text " + text + " but found " + items.size() + (String)(fullPath != null ? " on path " + fullPath : ""));
        }
        MenuItem menuItem = (MenuItem)items.get(0);
        this.ensureMenuItemIsUsable(menuItem, fullPath);
        return menuItem;
    }

    private MenuItem findMenuItemByPath(int topLevelPosition, int ... nestedItemsPositions) {
        MenuItem menuItem = this.findMenuItemByPosition(((MenuBar)this.getComponent()).getItems(), topLevelPosition, null);
        if (nestedItemsPositions.length > 0) {
            StringBuilder path = new StringBuilder().append(topLevelPosition);
            for (int position : nestedItemsPositions) {
                if (!menuItem.isParentItem()) {
                    throw new IllegalArgumentException("Menu item with text " + menuItem.getText() + " has no children. Make sure that the path is correct: " + path);
                }
                path.append(" / ").append(position);
                menuItem = this.findMenuItemByPosition(((SubMenu)menuItem.getSubMenu()).getItems(), position, path.toString());
            }
        }
        return menuItem;
    }

    private MenuItem findMenuItemByPosition(List<MenuItem> allItems, int position, String fullPath) {
        MenuItem menuItem = allItems.stream().filter(Component::isVisible).skip(position).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find menu item at position " + fullPath));
        this.ensureMenuItemIsUsable(menuItem, fullPath);
        return menuItem;
    }

    private void ensureMenuItemIsUsable(MenuItem menuItem, String fullPath) {
        if (!menuItem.isEnabled() || !menuItem.isVisible()) {
            throw new IllegalStateException("Menu item " + fullPath + " is not usable. " + PrettyPrintTreeKt.toPrettyTree((Component)menuItem));
        }
    }

    private void clickMenuItem(MenuItem menuItem) {
        if (menuItem.isCheckable()) {
            menuItem.setChecked(!menuItem.isChecked());
        }
        ComponentUtil.fireEvent((Component)menuItem, (ComponentEvent)new ClickEvent((Component)menuItem, true, 0, 0, 0, 0, 1, 0, false, false, false, false));
    }
}

