/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotOnFailureRule
extends TestWatcher {
    private HasDriver driverHolder;
    private boolean quitDriverOnFinish = false;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ScreenshotOnFailureRule.class);
    }

    public ScreenshotOnFailureRule(HasDriver driverHolder) {
        this.driverHolder = driverHolder;
    }

    public ScreenshotOnFailureRule(HasDriver driverHolder, boolean quitDriverOnFinish) {
        this.driverHolder = driverHolder;
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    public void setQuitDriverOnFinish(boolean quitDriverOnFinish) {
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    protected void failed(Throwable throwable, Description description) {
        super.failed(throwable, description);
        if (this.driverHolder.getDriver() == null) {
            return;
        }
        WebDriver realDriver = this.driverHolder.getDriver();
        while (realDriver instanceof WrapsDriver) {
            realDriver = ((WrapsDriver)realDriver).getWrappedDriver();
        }
        if (realDriver instanceof RemoteWebDriver && ((RemoteWebDriver)realDriver).getSessionId() == null) {
            ScreenshotOnFailureRule.getLogger().warn("Unable capture failure screenshot: web driver is no longer available");
            return;
        }
        try {
            BufferedImage screenshotImage = ImageIO.read(new ByteArrayInputStream((byte[])((TakesScreenshot)this.driverHolder.getDriver()).getScreenshotAs(OutputType.BYTES)));
            ImageFileUtil.createScreenshotDirectoriesIfNeeded();
            File errorScreenshotFile = this.getErrorScreenshotFile(description);
            ImageIO.write((RenderedImage)screenshotImage, "png", errorScreenshotFile);
            ScreenshotOnFailureRule.getLogger().info("Error screenshot written to: " + errorScreenshotFile.getAbsolutePath());
        }
        catch (IOException e1) {
            throw new RuntimeException("There was a problem grabbing and writing a screen shot of a test failure.", e1);
        }
    }

    protected void finished(Description description) {
        super.finished(description);
        if (this.quitDriverOnFinish && this.driverHolder != null && this.driverHolder.getDriver() != null) {
            this.driverHolder.getDriver().quit();
        }
    }

    protected File getErrorScreenshotFile(Description description) {
        return ImageFileUtil.getErrorScreenshotFile(description.getDisplayName() + ".png");
    }
}

