/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class ScreenshotOnFailureRule
extends TestWatcher {
    private static final Logger logger = Logger.getLogger(ScreenshotOnFailureRule.class.getName());
    private HasDriver driverHolder;
    private boolean quitDriverOnFinish = false;

    public ScreenshotOnFailureRule(HasDriver driverHolder) {
        this.driverHolder = driverHolder;
    }

    public ScreenshotOnFailureRule(HasDriver driverHolder, boolean quitDriverOnFinish) {
        this.driverHolder = driverHolder;
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    public void setQuitDriverOnFinish(boolean quitDriverOnFinish) {
        this.quitDriverOnFinish = quitDriverOnFinish;
    }

    protected void failed(Throwable throwable, Description description) {
        super.failed(throwable, description);
        if (this.driverHolder.getDriver() == null) {
            return;
        }
        try {
            BufferedImage screenshotImage = ImageIO.read(new ByteArrayInputStream((byte[])((TakesScreenshot)this.driverHolder.getDriver()).getScreenshotAs(OutputType.BYTES)));
            ImageFileUtil.createScreenshotDirectoriesIfNeeded();
            File errorScreenshotFile = this.getErrorScreenshotFile(description);
            ImageIO.write((RenderedImage)screenshotImage, "png", errorScreenshotFile);
            logger.info("Error screenshot written to: " + errorScreenshotFile.getAbsolutePath());
        }
        catch (IOException e1) {
            throw new RuntimeException("There was a problem grabbing and writing a screen shot of a test failure.", e1);
        }
    }

    protected void finished(Description description) {
        super.finished(description);
        if (this.quitDriverOnFinish && this.driverHolder != null && this.driverHolder.getDriver() != null) {
            this.driverHolder.getDriver().quit();
        }
    }

    protected File getErrorScreenshotFile(Description description) {
        return ImageFileUtil.getErrorScreenshotFile(description.getDisplayName() + ".png");
    }
}

