/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.commands;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.screenshot.ImageComparison;
import com.vaadin.testbench.screenshot.ImageFileUtil;
import com.vaadin.testbench.screenshot.ReferenceNameGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ScreenshotComparator {
    private static Boolean supportsElementScreenshots = null;

    public static boolean compareScreen(String referenceId, ReferenceNameGenerator referenceNameGenerator, ImageComparison imageComparison, TakesScreenshot takesScreenshot, HasCapabilities driver) throws IOException {
        Capabilities capabilities = driver.getCapabilities();
        String referenceName = referenceNameGenerator.generateName(referenceId, capabilities);
        for (int times = 0; times < Parameters.getMaxScreenshotRetries(); ++times) {
            boolean equal = imageComparison.imageEqualToReference(ScreenshotComparator.getScreenshot((TakesScreenshot)driver, takesScreenshot), referenceName, Parameters.getScreenshotComparisonTolerance(), capabilities);
            if (equal) {
                return true;
            }
            ScreenshotComparator.pause(Parameters.getScreenshotRetryDelay());
        }
        return false;
    }

    private static BufferedImage getScreenshot(TakesScreenshot driver, TakesScreenshot screenshotContext) throws IOException {
        boolean elementScreenshot = screenshotContext instanceof WebElement;
        if (elementScreenshot && supportsElementScreenshots == null) {
            try {
                byte[] screenshotBytes = (byte[])screenshotContext.getScreenshotAs(OutputType.BYTES);
                supportsElementScreenshots = true;
                return ImageIO.read(new ByteArrayInputStream(screenshotBytes));
            }
            catch (UnsupportedCommandException e) {
                supportsElementScreenshots = false;
            }
            catch (WebDriverException e) {
                if (e.getCause() instanceof UnsupportedCommandException) {
                    supportsElementScreenshots = false;
                }
                throw e;
            }
        }
        if (elementScreenshot && !supportsElementScreenshots.booleanValue()) {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream((byte[])driver.getScreenshotAs(OutputType.BYTES)));
            return ScreenshotComparator.cropToElement((WebElement)screenshotContext, image);
        }
        return ImageIO.read(new ByteArrayInputStream((byte[])screenshotContext.getScreenshotAs(OutputType.BYTES)));
    }

    public static BufferedImage cropToElement(WebElement element, BufferedImage fullScreen) throws IOException {
        Point loc = element.getLocation();
        Dimension size = element.getSize();
        int x = loc.x;
        int y = loc.y;
        int w = size.width;
        int h = size.height;
        if (x < 0 || x >= fullScreen.getWidth()) {
            throw new IOException("Element x is outside the screenshot (x: " + x + ", y: " + y + ")");
        }
        w = Math.min(fullScreen.getWidth() - x, w);
        if (y < 0 || y >= fullScreen.getHeight()) {
            throw new IOException("Element y is outside the screenshot (x: " + x + ", y: " + y + ")");
        }
        h = Math.min(fullScreen.getHeight() - y, h);
        return fullScreen.getSubimage(x, y, w, h);
    }

    public static boolean compareScreen(File reference, ImageComparison imageComparison, TakesScreenshot takesScreenshot, HasCapabilities driver) throws IOException {
        BufferedImage image = null;
        try {
            image = ImageIO.read(reference);
        }
        catch (IIOException iIOException) {
            // empty catch block
        }
        return ScreenshotComparator.compareScreen(image, reference.getName(), imageComparison, takesScreenshot, driver);
    }

    public static boolean compareScreen(BufferedImage reference, String referenceName, ImageComparison imageComparison, TakesScreenshot takesScreenshot, HasCapabilities driver) throws IOException {
        for (int times = 0; times < Parameters.getMaxScreenshotRetries(); ++times) {
            BufferedImage screenshotImage = ImageIO.read(new ByteArrayInputStream((byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES)));
            if (reference == null) {
                ImageFileUtil.createScreenshotDirectoriesIfNeeded();
                ImageIO.write((RenderedImage)screenshotImage, "png", ImageFileUtil.getErrorScreenshotFile(referenceName));
                ScreenshotComparator.getLogger().severe("No reference found for " + referenceName + " in " + ImageFileUtil.getScreenshotReferenceDirectory());
                return false;
            }
            if (imageComparison.imageEqualToReference(screenshotImage, reference, referenceName, Parameters.getScreenshotComparisonTolerance())) {
                return true;
            }
            ScreenshotComparator.pause(Parameters.getScreenshotRetryDelay());
        }
        return false;
    }

    private static Logger getLogger() {
        return Logger.getLogger(ScreenshotComparator.class.getName());
    }

    private static void pause(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

