/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.browser;

import com.vaadin.testbench.BrowserTest;
import com.vaadin.testbench.BrowserTestClass;
import com.vaadin.testbench.browser.BrowserExtension;
import com.vaadin.testbench.browser.CapabilitiesUtil;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import com.vaadin.testbench.parallel.TestNameSuffix;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.openqa.selenium.Capabilities;

public class MultipleBrowsersExtension
implements TestTemplateInvocationContextProvider,
BeforeAllCallback {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), BrowserTestClass.class) || AnnotationUtils.isAnnotated((AnnotatedElement)context.getRequiredTestMethod(), BrowserTest.class);
    }

    public void beforeAll(ExtensionContext context) {
        BrowserUtil.setBrowserFactory((TestBenchBrowserFactory)CapabilitiesUtil.getBrowserFactory(context));
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        return CapabilitiesUtil.getDesiredCapabilities(context).stream().map(dc -> new CapabilitiesTestTemplateInvocationContext(context, (Capabilities)dc));
    }

    private static class CapabilitiesTestTemplateInvocationContext
    implements TestTemplateInvocationContext {
        private final ExtensionContext context;
        private final Capabilities capabilities;

        public CapabilitiesTestTemplateInvocationContext(ExtensionContext context, Capabilities capabilities) {
            this.context = context;
            this.capabilities = capabilities;
        }

        public String getDisplayName(int invocationIndex) {
            return String.format("%s[%s]", this.context.getRequiredTestMethod().getName() + this.getTestNameSuffix(this.context), CapabilitiesUtil.getUniqueIdentifier(this.capabilities));
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new BrowserExtension(this.capabilities));
        }

        private String getTestNameSuffix(ExtensionContext context) {
            Optional testNameSuffixProperty = AnnotationUtils.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), TestNameSuffix.class);
            return testNameSuffixProperty.map(testNameSuffix -> "-" + System.getProperty(testNameSuffix.property())).orElse("");
        }
    }
}

