/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elements.AbstractComponentContainerElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.TabSheet")
public class TabSheetElement
extends AbstractComponentContainerElement {
    protected org.openqa.selenium.By byTabCell = By.xpath((String)"./div/table/tbody/tr/td[contains(normalize-space(concat(' ', @class, ' ')),normalize-space(' v-tabsheet-tabitem '))]");
    private static org.openqa.selenium.By byCaption = By.className((String)"v-captiontext");
    private static org.openqa.selenium.By byClosable = By.className((String)"v-tabsheet-caption-close");

    public List<String> getTabCaptions() {
        ArrayList<String> tabCaptions = new ArrayList<String>();
        for (WebElement tab : this.findElements(this.byTabCell)) {
            tabCaptions.add(this.getTabCaption(tab));
        }
        return tabCaptions;
    }

    public int getTabCount() {
        return this.findElements(this.byTabCell).size();
    }

    public void openTab(int index) {
        List tabs = this.findElements(this.byTabCell);
        if (index < 0 || index >= tabs.size()) {
            throw new NoSuchElementException("The tab sheet does not contain a tab with index " + index + ".");
        }
        this.openTab((WebElement)tabs.get(index));
    }

    public void openTab(String tabCaption) {
        for (WebElement tabCell : this.findElements(this.byTabCell)) {
            String currentCaption = this.getTabCaption(tabCell);
            boolean captionMatches = currentCaption != null && currentCaption.equals(tabCaption) || currentCaption == null && tabCaption == null;
            if (!captionMatches) continue;
            this.openTab(tabCell);
            return;
        }
        throw new NoSuchElementException("Tab with caption " + tabCaption + " was not found.");
    }

    private void openTab(WebElement tabCell) {
        List tabCaptions = tabCell.findElements(byCaption);
        if (!tabCaptions.isEmpty()) {
            ((WebElement)tabCaptions.get(0)).click();
            return;
        }
        List tabIcons = tabCell.findElements(By.className((String)"v-icon"));
        if (!tabIcons.isEmpty()) {
            ((WebElement)tabIcons.get(0)).click();
            return;
        }
        ((TestBenchElement)tabCell).click(10, 10, new Keys[0]);
    }

    public void closeTab(int index) {
        List tabs = this.findElements(this.byTabCell);
        if (index < 0 || index >= tabs.size()) {
            throw new NoSuchElementException("The tab sheet does not contain a tab with index " + index + ".");
        }
        WebElement tabCell = (WebElement)tabs.get(index);
        this.closeTab(tabCell);
    }

    public void closeTab(String tabCaption) {
        for (WebElement tabCell : this.findElements(this.byTabCell)) {
            String currentCaption = this.getTabCaption(tabCell);
            boolean captionMatches = currentCaption != null && currentCaption.equals(tabCaption) || currentCaption == null && tabCaption == null;
            if (!captionMatches) continue;
            this.closeTab(tabCell);
            return;
        }
    }

    private void closeTab(WebElement tabCell) {
        try {
            tabCell.findElement(byClosable).click();
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public <T extends AbstractElement> T getContent(Class<T> clazz) {
        return (T)((AbstractElement)TestBench.createElement(clazz, (WebElement)((AbstractComponentElement)this.$$(AbstractComponentElement.class).first()).getWrappedElement(), (TestBenchCommandExecutor)this.getCommandExecutor()));
    }

    private String getTabCaption(WebElement tabCell) {
        List captionElements = tabCell.findElements(byCaption);
        if (captionElements.isEmpty()) {
            return null;
        }
        return ((WebElement)captionElements.get(0)).getText();
    }
}

