/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractDateFieldElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.DateTimeField")
public class DateTimeFieldElement
extends AbstractDateFieldElement {
    public String getValue() {
        return this.findElement(By.tagName((String)"input")).getAttribute("value");
    }

    public void setValue(CharSequence chars) throws AbstractComponentElement.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        WebElement elem = this.findElement(By.tagName((String)"input"));
        TestBenchElement tbElement = (TestBenchElement)elem;
        this.clearElementClientSide((WebElement)tbElement);
        tbElement.sendKeys(new CharSequence[]{chars});
        tbElement.sendKeys(new CharSequence[]{Keys.TAB});
    }

    public void openPopup() {
        this.findElement(By.tagName((String)"button")).click();
    }

    public void setDateTime(LocalDateTime value) {
        this.setISOValue(value.format(this.getISOFormatter()));
    }

    public LocalDateTime getDateTime() {
        String value = this.getISOValue();
        if (value == null) {
            return null;
        }
        return LocalDateTime.parse(value, this.getISOFormatter());
    }

    protected DateTimeFormatter getISOFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }
}

