/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs.testbench;

import com.vaadin.flow.component.tabs.testbench.TabElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;

@Element(value="vaadin-tabs")
public class TabsElement
extends TestBenchElement {
    public void setSelectedTabIndex(int selectedTab) {
        this.setProperty("selected", selectedTab);
    }

    public int getSelectedTabIndex() {
        return this.getPropertyInteger(new String[]{"selected"});
    }

    public TabElement getSelectedTabElement() {
        return (TabElement)((TestBenchElement)this.executeScript("return arguments[0].children[arguments[0].selected];", new Object[]{this})).wrap(TabElement.class);
    }

    public TabElement getTabElement(String text) throws NoSuchElementException {
        int index = this.getTab(text);
        if (index == -1) {
            throw new NoSuchElementException("No tab with text '" + text + "' found");
        }
        return (TabElement)this.$(TabElement.class).get(index);
    }

    public int getTab(String text) {
        List<TabElement> children = this.getTabs();
        for (int i = 0; i < children.size(); ++i) {
            String tabLabel = children.get(i).getLabel();
            if (!text.equals(tabLabel)) continue;
            return i;
        }
        return -1;
    }

    public List<TabElement> getTabs() {
        List children = this.getChildren();
        return children.stream().map(it -> (TabElement)it.wrap(TabElement.class)).toList();
    }

    public List<String> getTabLabels() {
        List<TabElement> tabElements = this.getTabs();
        return tabElements.stream().map(TabElement::getLabel).toList();
    }
}

