/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabsVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-tabs")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.0"), @NpmPackage(value="@vaadin/tabs", version="24.2.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/tabs/src/vaadin-tabs.js")})
public class Tabs
extends Component
implements HasEnabled,
HasSize,
HasStyle,
HasThemeVariant<TabsVariant> {
    private static final String SELECTED = "selected";
    private transient Tab selectedTab;
    private boolean autoselect = true;

    public Tabs() {
        this.setSelectedIndex(-1);
        this.getElement().addPropertyChangeListener(SELECTED, (PropertyChangeListener & Serializable)event -> this.updateSelectedTab(event.isUserOriginated()));
    }

    public Tabs(Tab ... tabs) {
        this();
        this.add(tabs);
    }

    public Tabs(boolean autoselect, Tab ... tabs) {
        this();
        this.autoselect = autoselect;
        this.add(tabs);
    }

    @Deprecated
    public void add(Component ... components) {
        Objects.requireNonNull(components, "Tabs should not be null");
        boolean allComponentsAreTabs = Arrays.stream(components).map(tab -> Objects.requireNonNull(tab, "Tab to add cannot be null")).allMatch(component -> component instanceof Tab);
        if (!allComponentsAreTabs) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        Tab[] tabs = (Tab[])Arrays.copyOf(components, components.length, Tab[].class);
        this.add(tabs);
    }

    public void add(Tab ... tabs) {
        Objects.requireNonNull(tabs, "Tabs should not be null");
        boolean wasEmpty = this.getComponentCount() == 0;
        Arrays.stream(tabs).map(tab -> Objects.requireNonNull(tab, "Tab to add cannot be null")).map(Component::getElement).forEach(arg_0 -> Tabs.lambda$add$3(this.getElement(), arg_0));
        if (tabs.length == 0) {
            return;
        }
        if (wasEmpty && this.autoselect) {
            assert (this.getSelectedIndex() == -1);
            this.setSelectedIndex(0);
        } else {
            this.updateSelectedTab(false);
        }
    }

    @Deprecated
    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Tabs should not be null");
        boolean allComponentsAreTabs = Arrays.stream(components).map(tab -> Objects.requireNonNull(tab, "Tab to remove cannot be null")).allMatch(component -> component instanceof Tab);
        if (!allComponentsAreTabs) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        this.remove((Tab[])components);
    }

    /*
     * Unable to fully structure code
     */
    public void remove(Tab ... tabs) {
        selectedIndex = this.getSelectedIndex();
        lowerIndices = (int)Stream.of(tabs).map((Function<Tab, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, indexOf(com.vaadin.flow.component.tabs.Tab ), (Lcom/vaadin/flow/component/tabs/Tab;)Ljava/lang/Integer;)((Tabs)this)).filter((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$remove$6(int java.lang.Integer ), (Ljava/lang/Integer;)Z)((int)selectedIndex)).count();
        selectedTab = this.getSelectedTab();
        if (selectedTab == null) ** GOTO lbl-1000
        if (Stream.of(tabs).anyMatch((Predicate<Tab>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/vaadin/flow/component/tabs/Tab;)Z)((Tab)selectedTab))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isSelectedTab = v0;
        this.doRemoveTabs(tabs);
        newSelectedIndex = this.getSelectedIndex() - lowerIndices;
        if (newSelectedIndex > 0 && newSelectedIndex >= this.getComponentCount()) {
            newSelectedIndex = this.getComponentCount() - 1;
        }
        if (this.getComponentCount() == 0 || isSelectedTab && !this.isAutoselect()) {
            newSelectedIndex = -1;
        }
        if (newSelectedIndex != this.getSelectedIndex()) {
            this.setSelectedIndex(newSelectedIndex);
        } else {
            this.updateSelectedTab(false);
        }
    }

    private void doRemoveTabs(Tab ... tabs) {
        ArrayList<Tab> toRemove = new ArrayList<Tab>(tabs.length);
        for (Tab tab : tabs) {
            Objects.requireNonNull(tab, "Tab to remove cannot be null");
            Element parent = tab.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Remove of a tab with no parent does nothing.");
                continue;
            }
            if (this.getElement().equals((Object)parent)) {
                toRemove.add(tab);
                continue;
            }
            throw new IllegalArgumentException("The given tab (" + tab + ") is not a child of this tab");
        }
        toRemove.stream().map(Component::getElement).forEach(arg_0 -> Tabs.lambda$doRemoveTabs$7(this.getElement(), arg_0));
    }

    public void removeAll() {
        this.getElement().removeAllChildren();
        if (this.getSelectedIndex() > -1) {
            this.setSelectedIndex(-1);
        } else {
            this.updateSelectedTab(false);
        }
    }

    @Deprecated
    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Tab should not be null");
        if (!(component instanceof Tab)) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        this.addTabAtIndex(index, (Tab)component);
    }

    public void addTabAtIndex(int index, Tab tab) {
        Objects.requireNonNull(tab, "Tab should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a tab with a negative index");
        }
        this.getElement().insertChild(index, new Element[]{tab.getElement()});
        if (this.autoselect && this.getChildren().count() == 1L) {
            this.setSelectedIndex(0);
        } else if (index <= this.getSelectedIndex()) {
            this.setSelectedIndex(this.getSelectedIndex() + 1);
        }
    }

    @Deprecated
    public void replace(Component oldComponent, Component newComponent) {
        if (oldComponent != null && !(oldComponent instanceof Tab)) {
            throw new IllegalArgumentException("Removing a component other than a Tab is not supported.");
        }
        if (newComponent != null && !(newComponent instanceof Tab)) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        this.replace((Tab)oldComponent, (Tab)newComponent);
    }

    public void replace(Tab oldTab, Tab newTab) {
        if (oldTab != null || newTab != null) {
            if (oldTab == null) {
                this.add(newTab);
            } else if (newTab == null) {
                this.remove(oldTab);
            } else {
                this.doReplace(oldTab, newTab);
            }
        }
        this.updateSelectedTab(false);
    }

    private void doReplace(Tab oldTab, Tab newTab) {
        Element element = this.getElement();
        int oldIndex = element.indexOfChild(oldTab.getElement());
        int newIndex = element.indexOfChild(newTab.getElement());
        if (oldIndex >= 0 && newIndex >= 0) {
            element.insertChild(oldIndex, new Element[]{newTab.getElement()});
            element.insertChild(newIndex, new Element[]{oldTab.getElement()});
        } else if (oldIndex >= 0) {
            element.setChild(oldIndex, newTab.getElement());
        } else {
            this.add(newTab);
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJs("$0.addEventListener('items-changed', function(){ this.$server.updateSelectedTab(true); });", new Serializable[]{this.getElement()})));
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.addListener(SelectedChangeEvent.class, listener);
    }

    @Synchronize(property="selected", value={"selected-changed"})
    public int getSelectedIndex() {
        return this.getElement().getProperty(SELECTED, -1);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.getElement().setProperty(SELECTED, (double)selectedIndex);
    }

    public Tab getSelectedTab() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.getTabAt(selectedIndex);
    }

    public void setSelectedTab(Tab selectedTab) {
        if (selectedTab == null) {
            this.setSelectedIndex(-1);
            return;
        }
        int selectedIndex = this.indexOf(selectedTab);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Tab to select must be a child: " + selectedTab);
        }
        this.setSelectedIndex(selectedIndex);
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        if (orientation != null) {
            return Orientation.valueOf(orientation.toUpperCase(Locale.ROOT));
        }
        return Orientation.HORIZONTAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getElement().setProperty("orientation", orientation.name().toLowerCase(Locale.ENGLISH));
    }

    public void setFlexGrowForEnclosedTabs(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property must not be negative");
        }
        this.getChildren().forEach(tab -> ((Tab)((Object)tab)).setFlexGrow(flexGrow));
    }

    public void setAutoselect(boolean autoselect) {
        this.autoselect = autoselect;
    }

    public boolean isAutoselect() {
        return this.autoselect;
    }

    @ClientCallable
    private void updateSelectedTab(boolean changedFromClient) {
        if (this.getSelectedIndex() < -1) {
            this.setSelectedIndex(-1);
            return;
        }
        Tab currentlySelected = this.getSelectedTab();
        Tab previousTab = this.selectedTab;
        if (Objects.equals((Object)currentlySelected, (Object)this.selectedTab)) {
            return;
        }
        if (currentlySelected == null || currentlySelected.getElement().getNode().isEnabledSelf()) {
            this.selectedTab = currentlySelected;
            this.getChildren().filter(Tab.class::isInstance).map(Tab.class::cast).forEach(tab -> tab.setSelected(false));
            if (this.selectedTab != null) {
                this.selectedTab.setSelected(true);
            }
            this.fireEvent(new SelectedChangeEvent(this, previousTab, changedFromClient));
        } else {
            this.updateEnabled(currentlySelected);
            this.setSelectedTab(this.selectedTab);
        }
    }

    private void updateEnabled(Tab tab) {
        boolean enabled = tab.getElement().getNode().isEnabledSelf();
        Serializable rawValue = tab.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            tab.getElement().setProperty("disabled", enabled ? null : Boolean.TRUE.toString());
        } else {
            tab.setEnabled(enabled);
        }
    }

    @Deprecated
    public int indexOf(Component component) {
        Objects.requireNonNull(component, "Tab should not be null");
        if (!(component instanceof Tab)) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        return this.indexOf((Tab)component);
    }

    public int indexOf(Tab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("The 'tab' parameter cannot be null");
        }
        Iterator it = ((Stream)this.getChildren().sequential()).iterator();
        int index = 0;
        while (it.hasNext()) {
            Component next = (Component)it.next();
            if (((Object)((Object)tab)).equals(next)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getComponentCount() {
        return (int)this.getChildren().count();
    }

    @Deprecated
    public Component getComponentAt(int index) {
        return this.getTabAt(index);
    }

    public Tab getTabAt(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The 'index' argument should be greater than or equal to 0. It was: " + index);
        }
        return (Tab)((Object)((Stream)this.getChildren().sequential()).skip(index).findFirst().orElseThrow(() -> new IllegalArgumentException("The 'index' argument should not be greater than or equals to the number of children tabs. It was: " + index)));
    }

    @Deprecated
    public void addComponentAsFirst(Component component) {
        Objects.requireNonNull(component, "Tab should not be null");
        if (!(component instanceof Tab)) {
            throw new IllegalArgumentException("Adding a component other than a Tab is not supported.");
        }
        this.addTabAsFirst((Tab)component);
    }

    public void addTabAsFirst(Tab tab) {
        this.addTabAtIndex(0, tab);
    }

    private static /* synthetic */ void lambda$doRemoveTabs$7(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.removeChild(new Element[]{xva$0});
    }

    private static /* synthetic */ boolean lambda$remove$6(int selectedIndex, Integer index) {
        return index >= 0 && index < selectedIndex;
    }

    private static /* synthetic */ void lambda$add$3(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.appendChild(new Element[]{xva$0});
    }

    public static class SelectedChangeEvent
    extends ComponentEvent<Tabs> {
        private final Tab selectedTab;
        private final Tab previousTab;
        private final boolean initialSelection;

        public SelectedChangeEvent(Tabs source, Tab previousTab, boolean fromClient) {
            super((Component)source, fromClient);
            this.selectedTab = source.getSelectedTab();
            this.initialSelection = source.isAutoselect() && previousTab == null && !fromClient;
            this.previousTab = previousTab;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public Tab getPreviousTab() {
            return this.previousTab;
        }

        public boolean isInitialSelection() {
            return this.initialSelection;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

