/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.tabs.GeneratedVaadinTabs;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.shared.Registration;
import java.util.Locale;

public class Tabs
extends GeneratedVaadinTabs<Tabs>
implements HasOrderedComponents<Tabs>,
HasSize {
    public Tabs() {
    }

    public Tabs(Tab ... tabs) {
        this.add(tabs);
    }

    public void add(Tab ... tabs) {
        super.add((Component[])tabs);
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.addListener(SelectedChangeEvent.class, listener);
    }

    @Synchronize(property="selected", value={"selected-changed"})
    public int getSelectedIndex() {
        return this.getElement().getProperty("selected", 0);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.getElement().setProperty("selected", (double)selectedIndex);
    }

    public Tab getSelectedTab() {
        int selectedIndex = this.getSelectedIndex();
        Component selectedComponent = this.getComponentAt(selectedIndex);
        if (!(selectedComponent instanceof Tab)) {
            throw new IllegalStateException("Illegal component inside Tabs: " + selectedComponent);
        }
        return (Tab)selectedComponent;
    }

    public void setSelectedTab(Tab selectedTab) {
        int selectedIndex = this.indexOf(selectedTab);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Tab to select must be a child: " + (Object)((Object)selectedTab));
        }
        this.getElement().setProperty("selected", (double)selectedIndex);
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        if (orientation != null) {
            return Orientation.valueOf(orientation.toUpperCase(Locale.ROOT));
        }
        return Orientation.HORIZONTAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getElement().setProperty("orientation", orientation.name().toLowerCase());
    }

    public void setFlexGrowForEnclosedTabs(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property must not be negative");
        }
        this.getChildren().forEach(tab -> ((Tab)((Object)tab)).setFlexGrow(flexGrow));
    }

    @DomEvent(value="selected-changed")
    public static class SelectedChangeEvent
    extends ComponentEvent<Tabs> {
        public SelectedChangeEvent(Tabs source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

