/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.internal.hilla.FileRouterRequestUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.NavigationContext;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.flow.spring.security.WebIconsRequestMatcher;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class RequestUtil {
    private static final ThreadLocal<Boolean> ROUTE_PATH_MATCHER_RUNNING = new ThreadLocal();
    private final AuthenticatedAuthorizationManager<?> authenticatedAuthenticationManager = new AuthenticatedAuthorizationManager();
    private final AuthoritiesAuthorizationManager authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
    @Autowired
    private ObjectProvider<NavigationAccessControl> accessControl;
    @Autowired
    private VaadinConfigurationProperties configurationProperties;
    @Autowired(required=false)
    private EndpointRequestUtil endpointRequestUtil;
    @Autowired(required=false)
    private FileRouterRequestUtil fileRouterRequestUtil;
    @Autowired
    private ServletRegistrationBean<SpringServlet> springServletRegistration;
    private WebIconsRequestMatcher webIconsRequestMatcher;

    public boolean isFrameworkInternalRequest(HttpServletRequest request) {
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        return HandlerHelper.isFrameworkInternalRequest((String)vaadinMapping, (HttpServletRequest)request);
    }

    public boolean isEndpointRequest(HttpServletRequest request) {
        if (this.endpointRequestUtil != null) {
            return this.endpointRequestUtil.isEndpointRequest(request);
        }
        return false;
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        if (this.endpointRequestUtil != null) {
            return this.endpointRequestUtil.isAnonymousEndpoint(request);
        }
        return false;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public boolean isAllowedHillaView(HttpServletRequest request) {
        if (this.fileRouterRequestUtil != null) {
            return this.fileRouterRequestUtil.isRouteAllowed(request);
        }
        return false;
    }

    public boolean isAnonymousRoute(HttpServletRequest request) {
        if (ROUTE_PATH_MATCHER_RUNNING.get() == null) {
            ROUTE_PATH_MATCHER_RUNNING.set(Boolean.TRUE);
            try {
                boolean bl = this.isAnonymousRouteInternal(request);
                return bl;
            }
            finally {
                ROUTE_PATH_MATCHER_RUNNING.remove();
            }
        }
        return false;
    }

    public boolean isSecuredFlowRoute(HttpServletRequest request) {
        return this.isSecuredFlowRouteInternal(request);
    }

    public boolean isAnonymousHillaRoute(HttpServletRequest request) {
        if (this.fileRouterRequestUtil != null) {
            return this.fileRouterRequestUtil.isAnonymousRoute(request);
        }
        return false;
    }

    public boolean isSecuredHillaRoute(HttpServletRequest request) {
        if (this.fileRouterRequestUtil != null) {
            return this.fileRouterRequestUtil.isSecuredRoute(request);
        }
        return false;
    }

    AuthorizationResult authorizeHillaRoute(Supplier<? extends Authentication> authenticationSupplier, RequestAuthorizationContext context) {
        Set<String> authorities = this.getHillaAllowedAuthorities(context.getRequest());
        if (authorities.isEmpty()) {
            return this.authenticatedAuthenticationManager.authorize(authenticationSupplier, null);
        }
        return this.authoritiesAuthorizationManager.authorize(authenticationSupplier, authorities);
    }

    private Set<String> getHillaAllowedAuthorities(HttpServletRequest request) {
        if (this.fileRouterRequestUtil != null) {
            return this.fileRouterRequestUtil.getAllowedAuthorities(request);
        }
        return Collections.emptySet();
    }

    public boolean isCustomWebIcon(HttpServletRequest request) {
        if (this.webIconsRequestMatcher == null) {
            VaadinServletService vaadinService = ((SpringServlet)this.springServletRegistration.getServlet()).getService();
            if (vaadinService != null) {
                this.webIconsRequestMatcher = new WebIconsRequestMatcher((VaadinService)vaadinService, this.configurationProperties.getUrlMapping());
            } else {
                this.getLogger().debug("WebIconsRequestMatcher cannot be created because VaadinService is not yet available. This may happen after a hot-reload, and can cause requests for icons to be blocked by Spring Security.");
                return false;
            }
        }
        return this.webIconsRequestMatcher.matches(request);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public static RequestMatcher[] antMatchers(String ... patterns) {
        return (RequestMatcher[])Stream.of(patterns).map(PathPatternRequestMatcher::pathPattern).toArray(RequestMatcher[]::new);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public static RequestMatcher[] routeMatchers(String ... patterns) {
        return (RequestMatcher[])Stream.of(patterns).map(p -> PathPatternRequestMatcher.pathPattern((HttpMethod)HttpMethod.GET, (String)p)).toArray(RequestMatcher[]::new);
    }

    private boolean isSecuredFlowRouteInternal(HttpServletRequest request) {
        NavigationAccessControl navigationAccessControl = (NavigationAccessControl)this.accessControl.getObject();
        if (!navigationAccessControl.isEnabled()) {
            return false;
        }
        return this.isFlowRouteInternal(request);
    }

    private boolean isFlowRouteInternal(HttpServletRequest request) {
        String path = this.getRequestRoutePath(request);
        if (path == null) {
            return false;
        }
        SpringServlet servlet = (SpringServlet)this.springServletRegistration.getServlet();
        VaadinServletService service = servlet.getService();
        if (service == null) {
            return false;
        }
        Router router = service.getRouter();
        RouteRegistry routeRegistry = router.getRegistry();
        NavigationRouteTarget target = routeRegistry.getNavigationRouteTarget(path);
        if (target == null) {
            return false;
        }
        RouteTarget routeTarget = target.getRouteTarget();
        if (routeTarget == null) {
            return false;
        }
        Class targetView = routeTarget.getTarget();
        return targetView != null;
    }

    private boolean isAnonymousRouteInternal(HttpServletRequest request) {
        boolean isAllowed;
        String path = this.getRequestRoutePath(request);
        if (path == null) {
            return false;
        }
        SpringServlet servlet = (SpringServlet)this.springServletRegistration.getServlet();
        VaadinServletService service = servlet.getService();
        if (service == null) {
            return false;
        }
        Router router = service.getRouter();
        RouteRegistry routeRegistry = router.getRegistry();
        NavigationRouteTarget target = routeRegistry.getNavigationRouteTarget(path);
        if (target == null) {
            return false;
        }
        RouteTarget routeTarget = target.getRouteTarget();
        if (routeTarget == null) {
            return false;
        }
        Class targetView = routeTarget.getTarget();
        if (targetView == null) {
            return false;
        }
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        NavigationAccessControl navigationAccessControl = (NavigationAccessControl)this.accessControl.getObject();
        if (!navigationAccessControl.isEnabled()) {
            String message = "Navigation Access Control is disabled. Cannot determine if {} refers to a public view, thus access is denied. Please add an explicit request matcher rule for this URL.";
            if (productionMode) {
                this.getLogger().debug(message, (Object)path);
            } else {
                this.getLogger().info(message, (Object)path);
            }
            return false;
        }
        NavigationContext navigationContext = new NavigationContext(router, targetView, new Location(path, QueryParameters.full((Map)request.getParameterMap())), target.getRouteParameters(), null, role -> false, false, false);
        AccessCheckResult result = navigationAccessControl.checkAccess(navigationContext, productionMode);
        boolean bl = isAllowed = result.decision() == AccessCheckDecision.ALLOW;
        if (isAllowed) {
            this.getLogger().debug("{} refers to a public view", (Object)path);
        } else {
            this.getLogger().debug("Access to {} denied by Flow navigation access control. {}", (Object)path, (Object)result.reason());
        }
        return isAllowed;
    }

    private String getRequestRoutePath(HttpServletRequest request) {
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        String requestedPath = HandlerHelper.getRequestPathInsideContext((HttpServletRequest)request);
        return HandlerHelper.getPathIfInsideServlet((String)vaadinMapping, (String)requestedPath).map(path -> path.startsWith("/") ? path.substring(1) : path).orElse(null);
    }

    public String getUrlMapping() {
        return this.configurationProperties.getUrlMapping();
    }

    public String applyUrlMapping(String path) {
        return RequestUtil.applyUrlMapping(this.configurationProperties.getUrlMapping(), path);
    }

    static String applyUrlMapping(String urlMapping, String path) {
        urlMapping = urlMapping == null ? "" : urlMapping.replaceFirst("/\\*?$", "");
        if (path == null) {
            path = "";
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return urlMapping + "/" + path;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

