/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AccessPathChecker;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.RoutePathAccessChecker;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.NavigationAccessControlConfigurer;
import com.vaadin.flow.spring.security.NavigationAccessControlInitializer;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.SpringAccessPathChecker;
import com.vaadin.flow.spring.security.SpringNavigationAccessControl;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategy;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurityCustomizer.class})
@EnableConfigurationProperties(value={VaadinConfigurationProperties.class})
public class SpringSecurityAutoConfiguration {
    @Bean
    public VaadinDefaultRequestCache vaadinDefaultRequestCache() {
        return new VaadinDefaultRequestCache();
    }

    @Bean
    public NavigationAccessControlInitializer navigationAccessControlInitializer(NavigationAccessControl accessControl) {
        return new NavigationAccessControlInitializer(accessControl);
    }

    @Bean
    public NavigationAccessControl navigationAccessControl(List<NavigationAccessChecker> accessCheckerList, NavigationAccessControlConfigurer configurer) {
        return configurer.build(SpringNavigationAccessControl::new, accessCheckerList);
    }

    @Bean
    @ConditionalOnMissingBean
    NavigationAccessControlConfigurer navigationAccessControlConfigurerCustomizer() {
        return new NavigationAccessControlConfigurer().withAnnotatedViewAccessChecker().disabled();
    }

    @Bean
    public AnnotatedViewAccessChecker annotatedViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        return new AnnotatedViewAccessChecker(accessAnnotationChecker);
    }

    @Bean
    public RoutePathAccessChecker routePathAccessChecker(AccessPathChecker accessPathChecker) {
        return new RoutePathAccessChecker(accessPathChecker);
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessPathChecker accessPatchChecker(VaadinConfigurationProperties vaadinProperties, @Lazy WebInvocationPrivilegeEvaluator evaluator) {
        return new SpringAccessPathChecker(evaluator, vaadinProperties.getUrlMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessAnnotationChecker accessAnnotationChecker() {
        return new AccessAnnotationChecker();
    }

    @Bean
    public RequestUtil requestUtil() {
        return new RequestUtil();
    }

    @Bean
    @ConditionalOnMissingBean
    public VaadinRolePrefixHolder vaadinRolePrefixHolder(Optional<GrantedAuthorityDefaults> grantedAuthorityDefaults) {
        return new VaadinRolePrefixHolder(grantedAuthorityDefaults.map(GrantedAuthorityDefaults::getRolePrefix).orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean
    AuthenticationContext authenticationContext() {
        return new AuthenticationContext();
    }

    @Bean
    @ConditionalOnMissingBean
    SecurityContextHolderStrategy vaadinAwareSecurityContextHolderStrategy() {
        return new VaadinAwareSecurityContextHolderStrategy();
    }

    @Bean
    SmartInitializingSingleton securityContextHolderStrategyInitializer(SecurityContextHolderStrategy strategy) {
        return () -> SecurityContextHolder.setContextHolderStrategy((SecurityContextHolderStrategy)strategy);
    }
}

