/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.shared.ui.Transport;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.util.Assert;

public class AuthenticationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationContext.class);
    private LogoutSuccessHandler logoutSuccessHandler;
    private CompositeLogoutHandler logoutHandler;
    private VaadinRolePrefixHolder rolePrefixHolder;

    public <U> Optional<U> getAuthenticatedUser(Class<U> userType) {
        return AuthenticationContext.getAuthentication().map(Authentication::getPrincipal).map(userType::cast);
    }

    public Optional<String> getPrincipalName() {
        return AuthenticationContext.getAuthentication().map(Principal::getName);
    }

    public boolean isAuthenticated() {
        return AuthenticationContext.getAuthentication().map(Authentication::isAuthenticated).orElse(false);
    }

    public void logout() {
        boolean pushWebsocketConnected;
        UI ui = UI.getCurrent();
        boolean bl = pushWebsocketConnected = ui.getPushConfiguration().getTransport() == Transport.WEBSOCKET && ui.getInternals().getPushConnection().isConnected();
        if (pushWebsocketConnected) {
            ui.getPushConfiguration().setTransport(Transport.WEBSOCKET_XHR);
            ui.getPage().executeJs("return true", new Object[0]).then((SerializableConsumer & Serializable)ignored -> {
                LOGGER.debug("Switched to WEBSOCKET_XHR transport mode successfully for logout operation.");
                ui.getPushConfiguration().setTransport(Transport.WEBSOCKET);
                this.doLogout(ui);
            }, (SerializableConsumer & Serializable)exception -> {
                LOGGER.debug("Failed to switch to WEBSOCKET_XHR transport mode for logout operation. Logout is performed anyway even if browser shows 'disconnected' message and browser console has WebSocket errors. Received exception: {}", exception);
                ui.getPushConfiguration().setTransport(Transport.WEBSOCKET);
                this.doLogout(ui);
            });
        } else if (VaadinRequest.getCurrent() == null) {
            ui.getPage().executeJs("return true", new Object[0]).then((SerializableConsumer & Serializable)ignored -> this.doLogout(ui), (SerializableConsumer & Serializable)error -> this.doLogout(ui));
        } else {
            this.doLogout(ui);
        }
    }

    private void doLogout(UI ui) {
        HttpServletRequest request = VaadinServletRequest.getCurrent().getHttpServletRequest();
        HttpServletResponse response = Optional.ofNullable(VaadinServletResponse.getCurrent()).map(VaadinServletResponse::getHttpServletResponse).orElse(null);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.logoutHandler.logout(request, response, auth);
        ui.accessSynchronously((Command & Serializable)() -> {
            try {
                this.logoutSuccessHandler.onLogoutSuccess(request, response, auth);
            }
            catch (ServletException | IOException e) {
                LOGGER.warn("There was an error notifying the logout handler about the user logout", e);
            }
        });
    }

    public Collection<? extends GrantedAuthority> getGrantedAuthorities() {
        return AuthenticationContext.getAuthentication().filter(Authentication::isAuthenticated).map(Authentication::getAuthorities).orElse(Collections.emptyList());
    }

    private Stream<String> getGrantedAuthoritiesStream() {
        return this.getGrantedAuthorities().stream().map(GrantedAuthority::getAuthority);
    }

    public Collection<String> getGrantedRoles() {
        return this.getGrantedRolesStream().collect(Collectors.toSet());
    }

    private Stream<String> getGrantedRolesStream() {
        String rolePrefix = this.getRolePrefix();
        return this.getGrantedAuthoritiesStream().filter(ga -> ga.startsWith(rolePrefix)).map(ga -> ga.substring(rolePrefix.length()));
    }

    public boolean hasRole(String role) {
        return this.getGrantedRolesStream().anyMatch(role::equals);
    }

    public boolean hasAnyRole(Collection<String> roles) {
        if (roles.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one role to check");
        }
        return this.getGrantedRolesStream().anyMatch(roles::contains);
    }

    public boolean hasAnyRole(String ... roles) {
        return this.hasAnyRole(Set.of(roles));
    }

    public boolean hasAllRoles(Collection<String> roles) {
        if (roles.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one role to check");
        }
        return this.getGrantedRolesStream().collect(Collectors.toSet()).containsAll(roles);
    }

    public boolean hasAllRoles(String ... roles) {
        return this.hasAllRoles(Set.of(roles));
    }

    public boolean hasAuthority(String authority) {
        return this.getGrantedAuthoritiesStream().anyMatch(authority::equals);
    }

    public boolean hasAnyAuthority(Collection<String> authorities) {
        if (authorities.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one authority to check");
        }
        return this.getGrantedAuthoritiesStream().anyMatch(authorities::contains);
    }

    public boolean hasAnyAuthority(String ... authorities) {
        return this.hasAnyAuthority(Set.of(authorities));
    }

    public boolean hasAllAuthorities(Collection<String> authorities) {
        if (authorities.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one authority to check");
        }
        return this.getGrantedAuthoritiesStream().collect(Collectors.toSet()).containsAll(authorities);
    }

    public boolean hasAllAuthorities(String ... authorities) {
        return this.hasAllAuthorities(Set.of(authorities));
    }

    void setLogoutHandlers(LogoutSuccessHandler logoutSuccessHandler, List<LogoutHandler> logoutHandlers) {
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.logoutHandler = new CompositeLogoutHandler(logoutHandlers);
    }

    void setRolePrefixHolder(VaadinRolePrefixHolder rolePrefixHolder) {
        this.rolePrefixHolder = rolePrefixHolder;
    }

    private static Optional<Authentication> getAuthentication() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(auth -> !(auth instanceof AnonymousAuthenticationToken));
    }

    LogoutSuccessHandler getLogoutSuccessHandler() {
        return this.logoutSuccessHandler;
    }

    CompositeLogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    private String getRolePrefix() {
        return Optional.ofNullable(this.rolePrefixHolder).map(VaadinRolePrefixHolder::getRolePrefix).orElse("ROLE_");
    }

    public static void applySecurityConfiguration(HttpSecurity httpSecurity, AuthenticationContext authCtx) {
        httpSecurity.getObject();
        LogoutConfigurer logoutConfigurer = (LogoutConfigurer)httpSecurity.getConfigurer(LogoutConfigurer.class);
        authCtx.setLogoutHandlers(logoutConfigurer.getLogoutSuccessHandler(), logoutConfigurer.getLogoutHandlers());
    }

    static class CompositeLogoutHandler
    implements LogoutHandler,
    Serializable {
        private final List<LogoutHandler> logoutHandlers;

        public CompositeLogoutHandler(List<LogoutHandler> logoutHandlers) {
            Assert.notEmpty(logoutHandlers, (String)"LogoutHandlers are required");
            this.logoutHandlers = logoutHandlers;
        }

        public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
            for (LogoutHandler handler : this.logoutHandlers) {
                try {
                    handler.logout(request, response, authentication);
                }
                catch (IllegalStateException e) {
                    if (response == null && this.isContinueToNextHandler(request, handler)) continue;
                    throw e;
                }
            }
        }

        private boolean isContinueToNextHandler(HttpServletRequest request, LogoutHandler handler) {
            return handler instanceof SecurityContextLogoutHandler && (request.getSession(false) == null || !request.isRequestedSessionIdValid());
        }
    }
}

