/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.internal.hilla.FileRouterRequestUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.NavigationContext;
import com.vaadin.flow.spring.AuthenticationUtil;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.flow.spring.security.WebIconsRequestMatcher;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class RequestUtil {
    private static final ThreadLocal<Boolean> ROUTE_PATH_MATCHER_RUNNING = new ThreadLocal();
    @Autowired
    private ObjectProvider<NavigationAccessControl> accessControl;
    @Autowired
    private VaadinConfigurationProperties configurationProperties;
    @Autowired(required=false)
    private EndpointRequestUtil endpointRequestUtil;
    @Autowired(required=false)
    private FileRouterRequestUtil fileRouterRequestUtil;
    @Autowired
    private ServletRegistrationBean<SpringServlet> springServletRegistration;
    private WebIconsRequestMatcher webIconsRequestMatcher;

    public boolean isFrameworkInternalRequest(HttpServletRequest request) {
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        return HandlerHelper.isFrameworkInternalRequest((String)vaadinMapping, (HttpServletRequest)request);
    }

    public boolean isEndpointRequest(HttpServletRequest request) {
        if (this.endpointRequestUtil != null) {
            return this.endpointRequestUtil.isEndpointRequest(request);
        }
        return false;
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        if (this.endpointRequestUtil != null) {
            return this.endpointRequestUtil.isAnonymousEndpoint(request);
        }
        return false;
    }

    public boolean isAllowedHillaView(HttpServletRequest request) {
        if (this.fileRouterRequestUtil != null) {
            return this.fileRouterRequestUtil.isRouteAllowed(request);
        }
        return false;
    }

    public boolean isAnonymousRoute(HttpServletRequest request) {
        if (ROUTE_PATH_MATCHER_RUNNING.get() == null) {
            ROUTE_PATH_MATCHER_RUNNING.set(Boolean.TRUE);
            try {
                boolean bl = this.isAnonymousRouteInternal(PrincipalAwareRequestWrapper.wrap(request));
                return bl;
            }
            finally {
                ROUTE_PATH_MATCHER_RUNNING.remove();
            }
        }
        return false;
    }

    public boolean isCustomWebIcon(HttpServletRequest request) {
        if (this.webIconsRequestMatcher == null) {
            VaadinServletService vaadinService = ((SpringServlet)this.springServletRegistration.getServlet()).getService();
            if (vaadinService != null) {
                this.webIconsRequestMatcher = new WebIconsRequestMatcher((VaadinService)vaadinService, this.configurationProperties.getUrlMapping());
            } else {
                this.getLogger().debug("WebIconsRequestMatcher cannot be created because VaadinService is not yet available. This may happen after a hot-reload, and can cause requests for icons to be blocked by Spring Security.");
                return false;
            }
        }
        return this.webIconsRequestMatcher.matches(request);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public static RequestMatcher[] antMatchers(String ... patterns) {
        return (RequestMatcher[])Stream.of(patterns).map(AntPathRequestMatcher::new).toArray(RequestMatcher[]::new);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public static RequestMatcher[] routeMatchers(String ... patterns) {
        return (RequestMatcher[])Stream.of(patterns).map(p -> AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)p)).toArray(RequestMatcher[]::new);
    }

    public static RequestMatcher principalAwareRequestMatcher(RequestMatcher matcher) {
        return request -> matcher.matches(PrincipalAwareRequestWrapper.wrap(request));
    }

    private boolean isAnonymousRouteInternal(HttpServletRequest request) {
        boolean isAllowed;
        SpringServlet servlet;
        VaadinServletService service;
        String requestedPath;
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        Optional maybePath = HandlerHelper.getPathIfInsideServlet((String)vaadinMapping, (String)(requestedPath = HandlerHelper.getRequestPathInsideContext((HttpServletRequest)request)));
        if (maybePath.isEmpty()) {
            return false;
        }
        String path = (String)maybePath.get();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((service = (servlet = (SpringServlet)this.springServletRegistration.getServlet()).getService()) == null) {
            return false;
        }
        Router router = service.getRouter();
        RouteRegistry routeRegistry = router.getRegistry();
        NavigationRouteTarget target = routeRegistry.getNavigationRouteTarget(path);
        if (target == null) {
            return false;
        }
        RouteTarget routeTarget = target.getRouteTarget();
        if (routeTarget == null) {
            return false;
        }
        Class targetView = routeTarget.getTarget();
        if (targetView == null) {
            return false;
        }
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        NavigationAccessControl navigationAccessControl = (NavigationAccessControl)this.accessControl.getObject();
        if (!navigationAccessControl.isEnabled()) {
            String message = "Navigation Access Control is disabled. Cannot determine if {} refers to a public view, thus access is denied. Please add an explicit request matcher rule for this URL.";
            if (productionMode) {
                this.getLogger().debug(message, (Object)path);
            } else {
                this.getLogger().info(message, (Object)path);
            }
            return false;
        }
        NavigationContext navigationContext = new NavigationContext(router, targetView, new Location(path, QueryParameters.full((Map)request.getParameterMap())), target.getRouteParameters(), null, role -> false, false);
        AccessCheckResult result = navigationAccessControl.checkAccess(navigationContext, productionMode);
        boolean bl = isAllowed = result.decision() == AccessCheckDecision.ALLOW;
        if (isAllowed) {
            this.getLogger().debug("{} refers to a public view", (Object)path);
        } else {
            this.getLogger().debug("Access to {} denied by Flow navigation access control. {}", (Object)path, (Object)result.reason());
        }
        return isAllowed;
    }

    String getUrlMapping() {
        return this.configurationProperties.getUrlMapping();
    }

    public String applyUrlMapping(String path) {
        return RequestUtil.applyUrlMapping(this.configurationProperties.getUrlMapping(), path);
    }

    static String applyUrlMapping(String urlMapping, String path) {
        urlMapping = urlMapping == null ? "" : urlMapping.replaceFirst("/\\*?$", "");
        if (path == null) {
            path = "";
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return urlMapping + "/" + path;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    static class PrincipalAwareRequestWrapper
    extends HttpServletRequestWrapper {
        private PrincipalAwareRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public Principal getUserPrincipal() {
            try {
                return super.getUserPrincipal();
            }
            catch (UnsupportedOperationException e) {
                return AuthenticationUtil.getSecurityHolderAuthentication();
            }
        }

        static HttpServletRequest wrap(HttpServletRequest request) {
            if (request instanceof PrincipalAwareRequestWrapper) {
                return request;
            }
            HttpServletRequest maybeWrapper = request;
            while (maybeWrapper instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)maybeWrapper;
                if (wrapper instanceof PrincipalAwareRequestWrapper) {
                    return request;
                }
                maybeWrapper = (HttpServletRequest)wrapper.getRequest();
            }
            return new PrincipalAwareRequestWrapper(request);
        }
    }
}

