/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.spring.AuthenticationUtil;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import java.security.Principal;
import java.util.Optional;
import java.util.function.Predicate;

class SecurityUtil {
    SecurityUtil() {
    }

    static Principal getPrincipal(VaadinRequest request) {
        if (request == null) {
            return AuthenticationUtil.getSecurityHolderAuthentication();
        }
        return request.getUserPrincipal();
    }

    static Predicate<String> getRolesChecker(VaadinRequest request) {
        if (request == null) {
            return Optional.ofNullable(VaadinService.getCurrent()).map(service -> (Lookup)service.getContext().getAttribute(Lookup.class)).map(lookup -> (VaadinRolePrefixHolder)lookup.lookup(VaadinRolePrefixHolder.class)).map(VaadinRolePrefixHolder::getRolePrefix).map(AuthenticationUtil::getSecurityHolderRoleChecker).orElseGet(AuthenticationUtil::getSecurityHolderRoleChecker)::apply;
        }
        Optional.ofNullable(request.getService()).map(service -> (Lookup)service.getContext().getAttribute(Lookup.class)).map(lookup -> (VaadinRolePrefixHolder)lookup.lookup(VaadinRolePrefixHolder.class)).filter(prefixHolder -> !prefixHolder.isSet()).ifPresent(prefixHolder -> prefixHolder.resetRolePrefix(request));
        return arg_0 -> ((VaadinRequest)request).isUserInRole(arg_0);
    }
}

