/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.auth.DefaultMenuAccessControl;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import com.vaadin.flow.spring.SpringApplicationConfigurationFactory;
import com.vaadin.flow.spring.SpringLookupInitializer;
import com.vaadin.flow.spring.i18n.DefaultI18NProviderFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class VaadinApplicationConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationConfigurationFactory defaultApplicationConfigurationFactory() {
        return new SpringApplicationConfigurationFactory();
    }

    @Bean
    public ApplicationContextAware vaadinApplicationContextInitializer() {
        return new SpringLookupInitializer.SpringApplicationContextInit();
    }

    @Bean
    @ConditionalOnMissingBean(value={I18NProvider.class})
    @Conditional(value={DefaultI18NProviderFactory.class})
    public DefaultI18NProvider vaadinI18nProvider(@Value(value="${vaadin.i18n.location-pattern:classpath*:/vaadin-i18n/*.properties}") String locationPattern) {
        return DefaultI18NProviderFactory.create(locationPattern);
    }

    @Bean
    @ConditionalOnMissingBean(value={MenuAccessControl.class})
    public MenuAccessControl vaadinMenuAccessControl() {
        return new DefaultMenuAccessControl();
    }
}

