/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.server.ServiceDestroyEvent;
import com.vaadin.server.ServiceDestroyListener;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.internal.BeanStore;
import com.vaadin.spring.internal.BeanStoreRetrievalStrategy;
import com.vaadin.spring.internal.SessionLockingBeanStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class VaadinSessionScope
implements Scope,
BeanFactoryPostProcessor {
    public static final String VAADIN_SESSION_SCOPE_NAME = "vaadin-session";
    private static final Logger LOGGER = LoggerFactory.getLogger(VaadinSessionScope.class);
    private static BeanStoreRetrievalStrategy beanStoreRetrievalStrategy = new VaadinSessionBeanStoreRetrievalStrategy();

    public static synchronized void setBeanStoreRetrievalStrategy(BeanStoreRetrievalStrategy beanStoreRetrievalStrategy) {
        if (beanStoreRetrievalStrategy == null) {
            beanStoreRetrievalStrategy = new VaadinSessionBeanStoreRetrievalStrategy();
        }
        VaadinSessionScope.beanStoreRetrievalStrategy = beanStoreRetrievalStrategy;
    }

    public static synchronized BeanStoreRetrievalStrategy getBeanStoreRetrievalStrategy() {
        return beanStoreRetrievalStrategy;
    }

    public Object get(String s, ObjectFactory<?> objectFactory) {
        return this.getBeanStore().get(s, objectFactory);
    }

    public Object remove(String s) {
        return this.getBeanStore().remove(s);
    }

    public void registerDestructionCallback(String s, Runnable runnable) {
        this.getBeanStore().registerDestructionCallback(s, runnable);
    }

    public Object resolveContextualObject(String s) {
        return null;
    }

    public String getConversationId() {
        return VaadinSessionScope.getBeanStoreRetrievalStrategy().getConversationId();
    }

    private BeanStore getBeanStore() {
        return VaadinSessionScope.getBeanStoreRetrievalStrategy().getBeanStore();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        LOGGER.debug("Registering VaadinSession scope with bean factory [{}]", (Object)configurableListableBeanFactory);
        configurableListableBeanFactory.registerScope(VAADIN_SESSION_SCOPE_NAME, (Scope)this);
    }

    public static void cleanupSession(VaadinSession session) {
        assert (session != null);
        SessionAwareBeanStore beanStore = (SessionAwareBeanStore)session.getAttribute(SessionAwareBeanStore.class);
        if (beanStore != null) {
            LOGGER.debug("Vaadin session has been destroyed, destroying [{}]", (Object)beanStore);
            beanStore.destroy();
        }
    }

    static class SessionAwareBeanStore
    extends SessionLockingBeanStore
    implements ServiceDestroyListener {
        private static final long serialVersionUID = -8170074251720975071L;
        private static final Logger LOGGER = LoggerFactory.getLogger(SessionAwareBeanStore.class);

        SessionAwareBeanStore(VaadinSession session) {
            super(session, "Session:" + session.getSession().getId(), null);
            session.getService().addServiceDestroyListener((ServiceDestroyListener)this);
            session.setAttribute(BeanStore.class, (Object)this);
        }

        @Override
        public void destroy() {
            this.session.lock();
            try {
                try {
                    this.session.setAttribute(BeanStore.class, null);
                    this.session.getService().removeServiceDestroyListener((ServiceDestroyListener)this);
                }
                finally {
                    super.destroy();
                }
            }
            finally {
                this.session.unlock();
            }
        }

        public void serviceDestroy(ServiceDestroyEvent event) {
            LOGGER.debug("Vaadin service has been destroyed, destroying [{}]", (Object)this);
            this.destroy();
        }
    }

    public static class VaadinSessionBeanStoreRetrievalStrategy
    implements BeanStoreRetrievalStrategy {
        private VaadinSession getVaadinSession() {
            VaadinSession current = VaadinSession.getCurrent();
            if (current == null) {
                throw new IllegalStateException("No VaadinSession bound to current thread");
            }
            if (current.getState() != VaadinSession.State.OPEN) {
                throw new IllegalStateException("Current VaadinSession is not open");
            }
            return current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanStore getBeanStore() {
            VaadinSession session = this.getVaadinSession();
            session.lock();
            try {
                BeanStore beanStore = (BeanStore)session.getAttribute(BeanStore.class);
                if (beanStore == null) {
                    beanStore = new SessionAwareBeanStore(session);
                }
                BeanStore beanStore2 = beanStore;
                return beanStore2;
            }
            finally {
                session.unlock();
            }
        }

        @Override
        public String getConversationId() {
            return this.getVaadinSession().getSession().getId();
        }
    }
}

