/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class VaadinSavedRequestAwareAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final String SOURCE_HEADER = "source";
    private static final String RESULT_HEADER = "Result";
    private static final String VAADIN_CSRF_HEADER = "Vaadin-CSRF";
    private static final String DEFAULT_URL_HEADER = "Default-url";
    private static final String SAVED_URL_HEADER = "Saved-url";
    private static final String SPRING_CSRF_HEADER = "Spring-CSRF-header";
    private static final String SPRING_CSRF_TOKEN = "Spring-CSRF-token";
    private RequestCache requestCache = new HttpSessionRequestCache();

    public VaadinSavedRequestAwareAuthenticationSuccessHandler() {
        this.setRedirectStrategy((org.springframework.security.web.RedirectStrategy)new RedirectStrategy());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String storedServerNavigation = VaadinSavedRequestAwareAuthenticationSuccessHandler.getStoredServerNavigation(request);
        if (storedServerNavigation != null) {
            if (!"".equals(request.getContextPath())) {
                storedServerNavigation = "/" + storedServerNavigation;
            }
            response.setHeader(SAVED_URL_HEADER, storedServerNavigation);
        } else if (savedRequest != null) {
            response.setHeader(SAVED_URL_HEADER, savedRequest.getRedirectUrl());
        }
        if (VaadinSavedRequestAwareAuthenticationSuccessHandler.isTypescriptLogin(request)) {
            response.setHeader(DEFAULT_URL_HEADER, this.determineTargetUrl(request, response));
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }

    private static String getStoredServerNavigation(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute(ViewAccessChecker.SESSION_STORED_REDIRECT);
    }

    static boolean isTypescriptLogin(HttpServletRequest request) {
        return "typescript".equals(request.getHeader(SOURCE_HEADER));
    }

    public void setRequestCache(RequestCache requestCache) {
        super.setRequestCache(requestCache);
        this.requestCache = requestCache;
    }

    public static class RedirectStrategy
    extends DefaultRedirectStrategy {
        public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
            Object springCsrfTokenObject;
            String csrfToken;
            String savedRedirectUrl = response.getHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.SAVED_URL_HEADER);
            String redirectUrl = savedRedirectUrl != null ? savedRedirectUrl : url;
            if (!VaadinSavedRequestAwareAuthenticationSuccessHandler.isTypescriptLogin(request)) {
                super.sendRedirect(request, response, redirectUrl);
                return;
            }
            response.setHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.RESULT_HEADER, "success");
            HttpSession session = request.getSession(false);
            if (session != null && (csrfToken = (String)session.getAttribute(VaadinService.getCsrfTokenAttributeName())) != null) {
                response.setHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.VAADIN_CSRF_HEADER, csrfToken);
            }
            if ((springCsrfTokenObject = request.getAttribute(CsrfToken.class.getName())) instanceof CsrfToken) {
                CsrfToken springCsrfToken = (CsrfToken)springCsrfTokenObject;
                response.setHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.SPRING_CSRF_HEADER, springCsrfToken.getHeaderName());
                response.setHeader(VaadinSavedRequestAwareAuthenticationSuccessHandler.SPRING_CSRF_TOKEN, springCsrfToken.getToken());
            }
        }
    }
}

