/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.spring.security.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.stereotype.Component;

@Component
public class VaadinDefaultRequestCache
extends HttpSessionRequestCache {
    @Autowired
    private RequestUtil requestUtil;

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestUtil.isFrameworkInternalRequest(request)) {
            return;
        }
        if (this.requestUtil.isEndpointRequest(request)) {
            return;
        }
        if (this.isServiceWorkerInitiated(request)) {
            return;
        }
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Saving request to " + request.getRequestURI());
        super.saveRequest(request, response);
    }

    private boolean isServiceWorkerInitiated(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        return referer != null && referer.endsWith("sw.js");
    }
}

