/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.SpringInstantiator;
import com.vaadin.flow.spring.SpringVaadinSession;
import com.vaadin.flow.theme.AbstractTheme;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;

public class SpringVaadinServletService
extends VaadinServletService {
    private final transient ApplicationContext context;
    private final Registration serviceDestroyRegistration;
    private static final String SPRING_BOOT_WEBPROPROPERTIES_CLASS = "org.springframework.boot.autoconfigure.web.WebProperties";
    private static final String SPRING_BOOT_23_RESOURCES_CLASS = "org.springframework.boot.autoconfigure.web.ResourceProperties";

    public SpringVaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration, ApplicationContext context) {
        super(servlet, deploymentConfiguration);
        this.context = context;
        SessionDestroyListener & Serializable listener = (SessionDestroyListener & Serializable)event -> this.sessionDestroyed(event.getSession());
        Registration registration = this.addSessionDestroyListener(listener);
        this.serviceDestroyRegistration = this.addServiceDestroyListener((ServiceDestroyListener & Serializable)event -> this.serviceDestroyed(registration));
    }

    protected Optional<Instantiator> loadInstantiators() throws ServiceException {
        Optional spiInstantiator = super.loadInstantiators();
        List springInstantiators = this.context.getBeansOfType(Instantiator.class).values().stream().filter(instantiator -> instantiator.init((VaadinService)this)).collect(Collectors.toList());
        if (spiInstantiator.isPresent() && !springInstantiators.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because there are multiple eligible instantiator implementations: Java SPI registered instantiator " + spiInstantiator.get() + " and Spring instantiator beans: " + springInstantiators);
        }
        if (!spiInstantiator.isPresent() && springInstantiators.isEmpty()) {
            SpringInstantiator defaultInstantiator = new SpringInstantiator((VaadinService)this, this.context);
            defaultInstantiator.init((VaadinService)this);
            return Optional.of(defaultInstantiator);
        }
        return spiInstantiator.isPresent() ? spiInstantiator : springInstantiators.stream().findFirst();
    }

    protected VaadinSession createVaadinSession(VaadinRequest request) {
        return new SpringVaadinSession((VaadinService)this);
    }

    private void sessionDestroyed(VaadinSession session) {
        assert (session instanceof SpringVaadinSession);
        ((SpringVaadinSession)session).fireSessionDestroy();
    }

    private void serviceDestroyed(Registration registration) {
        registration.remove();
        this.serviceDestroyRegistration.remove();
    }

    public URL getStaticResource(String path) {
        URL resource = super.getStaticResource(path);
        if (resource == null) {
            resource = this.getResourceURL(path);
        }
        return resource;
    }

    public URL getResource(String path, WebBrowser browser, AbstractTheme theme) {
        URL resource = super.getResource(path, browser, theme);
        if (resource == null) {
            resource = this.getResourceURL(this.getThemeResolvedPath(path, browser, theme));
        }
        return resource;
    }

    private URL getResourceURL(String path) {
        URL url = this.getResourceURLSpringBoot24(path);
        if (url == null) {
            url = this.getResourceURLSpringBoot23(path);
        }
        return url;
    }

    private URL getResourceURLSpringBoot24(String path) {
        if (!this.isSpringBootConfigured()) {
            return null;
        }
        for (String prefix : ((WebProperties)this.context.getBean(WebProperties.class)).getResources().getStaticLocations()) {
            Resource resource = this.context.getResource(this.getFullPath(path, prefix));
            if (resource == null) continue;
            try {
                return resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private URL getResourceURLSpringBoot23(String path) {
        String[] locations;
        if (!this.isSpringBoot23Configured()) {
            return null;
        }
        Class<?> resourcesClass = SpringVaadinServletService.resolveClass(SPRING_BOOT_23_RESOURCES_CLASS);
        Method method = ReflectionUtils.findMethod(resourcesClass, (String)"getStaticLocations");
        Object resourceProperties = this.context.getBean(resourcesClass);
        for (String prefix : locations = (String[])ReflectionUtils.invokeMethod((Method)method, (Object)resourceProperties)) {
            Resource resource = this.context.getResource(this.getFullPath(path, prefix));
            if (resource == null) continue;
            try {
                return resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getFullPath(String path, String prefix) {
        if (prefix.endsWith("/") && path.startsWith("/")) {
            return prefix + path.substring(1);
        }
        return prefix + path;
    }

    private boolean isSpringBootConfigured() {
        Class<?> resourcesClass = SpringVaadinServletService.resolveClass(SPRING_BOOT_WEBPROPROPERTIES_CLASS);
        if (resourcesClass != null) {
            return this.context.getBeanNamesForType(resourcesClass).length != 0;
        }
        return false;
    }

    private boolean isSpringBoot23Configured() {
        Class<?> resourcesClass = SpringVaadinServletService.resolveClass(SPRING_BOOT_23_RESOURCES_CLASS);
        if (resourcesClass != null) {
            return this.context.getBeanNamesForType(resourcesClass).length != 0;
        }
        return false;
    }

    private static Class<?> resolveClass(String clazzName) {
        try {
            return Class.forName(clazzName, false, SpringVaadinServletService.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String path, WebBrowser browser, AbstractTheme theme) {
        URL resourceURL;
        InputStream resourceAsStream = super.getResourceAsStream(path, browser, theme);
        if (resourceAsStream == null && (resourceURL = this.getResourceURL(this.getThemeResolvedPath(path, browser, theme))) != null) {
            try {
                resourceAsStream = resourceURL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resourceAsStream;
    }

    private String getThemeResolvedPath(String url, WebBrowser browser, AbstractTheme theme) {
        String themeUrl;
        String resourceUrl = this.resolveResource(url, browser);
        if (theme != null && !resourceUrl.equals(themeUrl = theme.translateUrl(resourceUrl)) && this.getResourceURL(themeUrl) != null) {
            return themeUrl;
        }
        return resourceUrl;
    }
}

