/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.RouteRegistry;
import com.vaadin.flow.server.startup.ServletVerifier;
import com.vaadin.flow.spring.VaadinScanPackagesRegistrar;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class VaadinServletContextInitializer
implements ServletContextInitializer {
    private ApplicationContext appContext;

    public VaadinServletContextInitializer(ApplicationContext context) {
        this.appContext = context;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        ServletVerifier.verifyServletVersion();
        RouteRegistry registry = RouteRegistry.getInstance((ServletContext)servletContext);
        if (!registry.navigationTargetsInitialized()) {
            servletContext.addListener((EventListener)((Object)new RouteServletContextListener()));
        }
        if (!registry.errorNavigationTargetsInitialized()) {
            servletContext.addListener((EventListener)((Object)new ErrorParameterServletContextListener()));
        }
        servletContext.addListener((EventListener)((Object)new AnnotationValidatorServletContextListener()));
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotation(packages, Stream.of(annotations));
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, Stream<Class<? extends Annotation>> annotations) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setResourceLoader((ResourceLoader)this.appContext);
        annotations.forEach(annotation -> scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation)));
        return packages.stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)scanner).findCandidateComponents(arg_0)).flatMap(set -> set.stream()).map(this::getBeanClass);
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, Class<?> type) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setResourceLoader((ResourceLoader)this.appContext);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(type));
        return packages.stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)scanner).findCandidateComponents(arg_0)).flatMap(set -> set.stream()).map(this::getBeanClass);
    }

    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        Class beanClass;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
        if (definition.hasBeanClass()) {
            beanClass = definition.getBeanClass();
        } else {
            try {
                beanClass = definition.resolveBeanClass(this.appContext.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return beanClass;
    }

    private Collection<String> getRoutePackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getCustomElementPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getVerifiableAnnotationPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getErrorParameterPackages() {
        return Stream.concat(Stream.of(HasErrorParameter.class.getPackage().getName()), this.getDefaultPackages().stream()).collect(Collectors.toSet());
    }

    private List<String> getDefaultPackages() {
        List packagesList = Collections.emptyList();
        if (this.appContext.getBeanNamesForType(VaadinScanPackagesRegistrar.VaadinScanPackages.class).length > 0) {
            VaadinScanPackagesRegistrar.VaadinScanPackages packages = (VaadinScanPackagesRegistrar.VaadinScanPackages)this.appContext.getBean(VaadinScanPackagesRegistrar.VaadinScanPackages.class);
            packagesList = packages.getScanPackages();
        }
        if (!packagesList.isEmpty()) {
            LoggerFactory.getLogger(VaadinServletContextInitializer.class).trace("Using explicitly configured packages for scan Vaadin types at startup {}", packagesList);
        } else if (AutoConfigurationPackages.has((BeanFactory)this.appContext)) {
            packagesList = AutoConfigurationPackages.get((BeanFactory)this.appContext);
        }
        return packagesList;
    }

    private class AnnotationValidatorServletContextListener
    extends AbstractAnnotationValidator
    implements ServletContextListener {
        private AnnotationValidatorServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent event) {
            Stream<Class> annotations = this.getAnnotations().stream().map(annotation -> annotation);
            this.validateClasses(VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), annotations).collect(Collectors.toList()));
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }

        protected List<Class<?>> getAnnotations() {
            return Arrays.asList(AnnotationValidator.class.getAnnotation(HandlesTypes.class).value());
        }
    }

    private class ErrorParameterServletContextListener
    implements ServletContextListener {
        private ErrorParameterServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent event) {
            RouteRegistry registry = RouteRegistry.getInstance((ServletContext)event.getServletContext());
            if (registry.errorNavigationTargetsInitialized()) {
                return;
            }
            Stream<Class> hasErrorComponents = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getErrorParameterPackages(), HasErrorParameter.class).filter(Component.class::isAssignableFrom).map(clazz -> clazz);
            registry.setErrorNavigationTargets(hasErrorComponents.collect(Collectors.toSet()));
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    private class RouteServletContextListener
    extends AbstractRouteRegistryInitializer
    implements ServletContextListener {
        private RouteServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent event) {
            RouteRegistry registry = RouteRegistry.getInstance((ServletContext)event.getServletContext());
            if (registry.navigationTargetsInitialized()) {
                return;
            }
            try {
                Set navigationTargets = this.validateRouteClasses(VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getRoutePackages(), new Class[]{Route.class, RouteAlias.class}));
                registry.setNavigationTargets(navigationTargets);
            }
            catch (InvalidRouteConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }
}

