/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.spring.SpringVaadinServletService;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringServlet
extends VaadinServlet {
    private final ApplicationContext context;

    public SpringServlet(ApplicationContext context) {
        this.context = context;
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        SpringVaadinServletService service = new SpringVaadinServletService(this, deploymentConfiguration, this.context);
        service.init();
        return service;
    }

    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {
        Properties properties = new Properties(initParameters);
        this.config(properties);
        return super.createDeploymentConfiguration(properties);
    }

    private void config(Properties properties) {
        this.setProperty("productionMode", properties);
        this.setProperty("disable-xsrf-protection", properties);
        this.setProperty("closeIdleSessions", properties);
        this.setProperty("heartbeatInterval", properties);
        this.setProperty("sendUrlsAsParameters", properties);
        this.setProperty("pushMode", properties);
        this.setProperty("pushLongPollingSuspendTimeout", properties);
        this.setProperty("requestTiming", properties);
        this.setProperty("disable.webjars", properties);
        this.setProperty("frontend.url.es5", properties);
        this.setProperty("frontend.url.es6", properties);
        this.setProperty("i18n.provider", properties);
    }

    private void setProperty(String property, Properties properties) {
        this.setProperty("vaadin." + property, property, properties);
    }

    private void setProperty(String envProperty, String initParam, Properties properties) {
        Environment env = (Environment)this.context.getBean(Environment.class);
        String productionMode = env.getProperty(envProperty);
        if (productionMode != null) {
            properties.put(initParam, productionMode);
        }
    }
}

