/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.testbench;

import com.vaadin.flow.component.spreadsheet.testbench.SpreadsheetElement;
import com.vaadin.testbench.TestBenchElement;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class SheetCellElement
extends TestBenchElement {
    private SpreadsheetElement parent;

    public void setValue(String newValue) {
        if (this.isNormalCell()) {
            this.waitUntil(driver -> {
                this.doubleClick();
                return this.parent.getCellValueInput().isDisplayed();
            });
            WebElement cellValueInput = this.parent.getCellValueInput();
            this.executeScript("arguments[0].value=''", new Object[]{((TestBenchElement)cellValueInput).getWrappedElement()});
            new Actions(this.getDriver()).moveToElement(cellValueInput).sendKeys(new CharSequence[]{newValue}).build().perform();
            new Actions(this.getDriver()).moveToElement(cellValueInput).sendKeys(new CharSequence[]{Keys.TAB}).build().perform();
            this.getCommandExecutor().waitForVaadin();
        }
    }

    public String getValue() {
        return this.getText();
    }

    public boolean isCellSelected() {
        return this.parent.isElementSelected((WebElement)this);
    }

    public boolean isNormalCell() {
        List children = this.findElements(By.cssSelector((String)"*"));
        return this.noneOfTheElementsIsWidget(children);
    }

    private boolean noneOfTheElementsIsWidget(List<WebElement> children) {
        for (WebElement e : children) {
            if (!Optional.ofNullable(e.getDomAttribute("class")).orElse("").contains("v-widget")) continue;
            return false;
        }
        return true;
    }

    public boolean hasPopupButton() {
        List buttons = this.findElements(By.className((String)"popupbutton"));
        return !buttons.isEmpty();
    }

    public void popupButtonClick() {
        if (!this.hasPopupButton()) {
            throw new IllegalStateException("This cell doesn't have a PopupuButton");
        }
        this.findElement(By.className((String)"popupbutton")).click();
    }

    void setParent(SpreadsheetElement parent) {
        this.parent = parent;
    }

    public boolean hasInvalidFormulaIndicator() {
        List indicators = this.findElements(By.className((String)"cell-invalidformula-triangle"));
        return !indicators.isEmpty();
    }

    public boolean hasCommentIndicator() {
        List indicators = this.findElements(By.className((String)"cell-comment-triangle"));
        return !indicators.isEmpty();
    }
}

