/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.CTSerAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMultiLvlStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;

public abstract class AbstractSeriesReader<CT_SER_TYPE extends XmlObject, SERIES_DATA_TYPE extends AbstractSeriesData> {
    private final XmlObject ctChart;
    private final Spreadsheet spreadsheet;
    private final boolean is3d;
    protected final boolean showDataInHiddenCells;

    public AbstractSeriesReader(XmlObject ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        this(ctChart, spreadsheet, false, showDataInHiddenCells);
    }

    public AbstractSeriesReader(XmlObject ctChart, Spreadsheet spreadsheet, boolean is3d, boolean showDataInHiddenCells) {
        this.ctChart = ctChart;
        this.spreadsheet = spreadsheet;
        this.is3d = is3d;
        this.showDataInHiddenCells = showDataInHiddenCells;
    }

    protected abstract SERIES_DATA_TYPE createSeriesDataObject(CT_SER_TYPE var1);

    public List<SERIES_DATA_TYPE> getSeries() {
        ArrayList<SERIES_DATA_TYPE> list = new ArrayList<SERIES_DATA_TYPE>();
        for (XmlObject serie : this.getSerList()) {
            list.add(this.createAndFillSeriesDataObject(serie));
        }
        return list;
    }

    private SERIES_DATA_TYPE createAndFillSeriesDataObject(CT_SER_TYPE serie) {
        SERIES_DATA_TYPE seriesData = this.createSeriesDataObject(serie);
        this.fillSeriesData(seriesData, serie);
        return seriesData;
    }

    protected XmlObject getChart() {
        return this.ctChart;
    }

    private List<CT_SER_TYPE> getSerList() {
        return (List)Utils.callMethodUsingReflection(this.ctChart, "getSerList");
    }

    protected void fillSeriesData(SERIES_DATA_TYPE seriesData, CT_SER_TYPE serie) {
        CTSerAdapter ctSerAdapter = new CTSerAdapter((XmlObject)serie);
        ((AbstractSeriesData)seriesData).name = this.tryGetSeriesName(ctSerAdapter.getTx());
        this.createCategories(ctSerAdapter.getCat(), seriesData);
        this.createSeriesDataPoints(ctSerAdapter.getVal(), seriesData);
        ((AbstractSeriesData)seriesData).is3d = this.is3d;
    }

    protected void createCategories(CTAxDataSource axisDataSource, SERIES_DATA_TYPE seriesData) {
        if (axisDataSource == null) {
            return;
        }
        final List<CellReference> cellReferences = this.getCategoryCellReferences(axisDataSource);
        ((AbstractSeriesData)seriesData).categories = new ArrayList<String>(new AbstractList<String>(){

            @Override
            public String get(int index) {
                return Utils.getStringValue((CellReference)cellReferences.get(index), AbstractSeriesReader.this.getSpreadsheet());
            }

            @Override
            public int size() {
                return cellReferences.size();
            }
        });
        this.handleReferencedValueUpdates(cellReferences, seriesData, ValueUpdateMode.CATEGORIES);
    }

    private List<CellReference> getCategoryCellReferences(CTAxDataSource axisDataSource) {
        if (axisDataSource.isSetStrRef()) {
            String formula = axisDataSource.getStrRef().getF();
            return Utils.getAllReferencedCells(formula, this.spreadsheet, this.showDataInHiddenCells);
        }
        if (axisDataSource.isSetNumRef()) {
            String formula = axisDataSource.getNumRef().getF();
            return Utils.getAllReferencedCells(formula, this.spreadsheet, this.showDataInHiddenCells);
        }
        if (axisDataSource.isSetMultiLvlStrRef()) {
            return this.tryHandleMultilevelCategories(axisDataSource);
        }
        return Collections.emptyList();
    }

    private List<CellReference> tryHandleMultilevelCategories(CTAxDataSource axisDataSource) {
        CTMultiLvlStrRef multiLvlStrRef = axisDataSource.getMultiLvlStrRef();
        String formula = multiLvlStrRef.getF();
        List<CellReference> allReferencedCells = Utils.getAllReferencedCells(formula, this.spreadsheet, this.showDataInHiddenCells);
        if (!multiLvlStrRef.getMultiLvlStrCache().isSetPtCount()) {
            return allReferencedCells;
        }
        return this.getCategoryCellsFromMultilevelReferences(multiLvlStrRef, allReferencedCells);
    }

    private List<CellReference> getCategoryCellsFromMultilevelReferences(CTMultiLvlStrRef multiLvlStrRef, final List<CellReference> allReferencedCells) {
        CellReference firstCell = allReferencedCells.get(0);
        CellReference lastCell = allReferencedCells.get(allReferencedCells.size() - 1);
        final int width = lastCell.getCol() - firstCell.getCol() + 1;
        int height = lastCell.getRow() - firstCell.getRow() + 1;
        final int numOfPointsInCache = (int)multiLvlStrRef.getMultiLvlStrCache().getPtCount().getVal();
        final int numOfLevels = allReferencedCells.size() / numOfPointsInCache;
        if (numOfLevels == width) {
            return new AbstractList<CellReference>(this){

                @Override
                public CellReference get(int index) {
                    return (CellReference)allReferencedCells.get(numOfLevels - 1 + index * numOfLevels);
                }

                @Override
                public int size() {
                    return numOfPointsInCache;
                }
            };
        }
        if (numOfLevels == height) {
            return new AbstractList<CellReference>(this){

                @Override
                public CellReference get(int index) {
                    return (CellReference)allReferencedCells.get(allReferencedCells.size() - width + index);
                }

                @Override
                public int size() {
                    return numOfPointsInCache;
                }
            };
        }
        System.err.println("Could not handle multilevel categories");
        return Collections.emptyList();
    }

    protected void createSeriesDataPoints(CTNumDataSource val, SERIES_DATA_TYPE seriesData) {
        final String formula = val.getNumRef().getF();
        List<CellReference> ptList = Utils.getAllReferencedCells(formula, this.spreadsheet, this.showDataInHiddenCells);
        ArrayList<AbstractSeriesData.SeriesPoint> list = new ArrayList<AbstractSeriesData.SeriesPoint>();
        for (int i = 0; i < ptList.size(); ++i) {
            Double cellNumericValue = this.getNumericValueFromCellRef(ptList.get(i));
            list.add(new AbstractSeriesData.SeriesPoint(i, cellNumericValue));
        }
        ((AbstractSeriesData)seriesData).seriesData = list;
        ((AbstractSeriesData)seriesData).tooltipDecimals = this.calculateDecimalsForTooltip(ptList);
        this.handleReferencedValueUpdates(ptList, seriesData, ValueUpdateMode.Y_VALUES);
        ((AbstractSeriesData)seriesData).dataSelectListener = new AbstractSeriesData.DataSelectListener(){

            @Override
            public void dataSelected() {
                AreaReference[] areaReferences = Utils.getAreaReferences(AbstractSeriesReader.this.getSpreadsheet().getWorkbook().getSpreadsheetVersion(), formula);
                AbstractSeriesReader.this.getSpreadsheet().setSelectionRange(areaReferences[0].getFirstCell().getRow(), areaReferences[0].getFirstCell().getCol(), areaReferences[areaReferences.length - 1].getLastCell().getRow(), areaReferences[areaReferences.length - 1].getLastCell().getCol());
            }
        };
    }

    private int calculateDecimalsForTooltip(List<CellReference> ptList) {
        Sheet sheet;
        if (ptList.size() <= 0) {
            return -1;
        }
        CellReference ref = ptList.get(0);
        Cell cell = this.spreadsheet.getCell(ref, sheet = this.spreadsheet.getWorkbook().getSheet(ref.getSheetName()));
        if (cell == null) {
            return -1;
        }
        CellStyle style = cell.getCellStyle();
        String styleString = style.getDataFormatString();
        if (styleString == null || styleString.isEmpty() || styleString.equals("General")) {
            return -1;
        }
        int sep = 46;
        int sepIndex = styleString.trim().lastIndexOf(sep);
        int decimalCount = sepIndex < 0 ? 0 : styleString.length() - sepIndex - 1;
        return decimalCount;
    }

    void onValueChange(List<CellReference> referencedCells, SERIES_DATA_TYPE seriesData, ValueUpdateMode updateMode, Spreadsheet.ValueChangeEvent event) {
        if (((AbstractSeriesData)seriesData).dataUpdateListener == null) {
            return;
        }
        for (CellReference changedCell : event.getChangedCells()) {
            this.updatePoint(referencedCells, seriesData, updateMode, changedCell);
        }
    }

    protected void handleReferencedValueUpdates(final List<CellReference> referencedCells, SERIES_DATA_TYPE seriesData, ValueUpdateMode updateMode) {
        this.spreadsheet.addCellValueChangeListener(new Spreadsheet.CellValueChangeListener(){
            final /* synthetic */ AbstractSeriesData val$seriesData;
            final /* synthetic */ ValueUpdateMode val$updateMode;
            {
                this.val$seriesData = abstractSeriesData;
                this.val$updateMode = valueUpdateMode;
            }

            @Override
            public void onCellValueChange(Spreadsheet.CellValueChangeEvent event) {
                AbstractSeriesReader.this.onValueChange(referencedCells, this.val$seriesData, this.val$updateMode, event);
            }
        });
        this.spreadsheet.addFormulaValueChangeListener(new Spreadsheet.FormulaValueChangeListener(){
            final /* synthetic */ AbstractSeriesData val$seriesData;
            final /* synthetic */ ValueUpdateMode val$updateMode;
            {
                this.val$seriesData = abstractSeriesData;
                this.val$updateMode = valueUpdateMode;
            }

            @Override
            public void onFormulaValueChange(Spreadsheet.FormulaValueChangeEvent event) {
                AbstractSeriesReader.this.onValueChange(referencedCells, this.val$seriesData, this.val$updateMode, event);
            }
        });
    }

    private void updatePoint(List<CellReference> referencedCells, SERIES_DATA_TYPE seriesData, ValueUpdateMode updateMode, CellReference changedCell) {
        CellReference absoluteChangedCell = SpreadsheetUtil.relativeToAbsolute(this.spreadsheet, changedCell);
        if (!referencedCells.contains(absoluteChangedCell)) {
            return;
        }
        int index = referencedCells.indexOf(absoluteChangedCell);
        if (updateMode != ValueUpdateMode.CATEGORIES) {
            AbstractSeriesData.SeriesPoint item = ((AbstractSeriesData)seriesData).seriesData.get(index);
            Double cellValue = Utils.getNumericValue(absoluteChangedCell, this.spreadsheet);
            if (updateMode == ValueUpdateMode.X_VALUES) {
                item.xValue = cellValue;
                ((AbstractSeriesData)seriesData).dataUpdateListener.xDataModified(index, cellValue);
            }
            if (updateMode == ValueUpdateMode.Y_VALUES) {
                item.yValue = cellValue;
                ((AbstractSeriesData)seriesData).dataUpdateListener.yDataModified(index, cellValue);
            }
            if (updateMode == ValueUpdateMode.Z_VALUES) {
                item.zValue = cellValue;
                ((AbstractSeriesData)seriesData).dataUpdateListener.zDataModified(index, cellValue);
            }
        } else {
            String cellValue = Utils.getStringValue(absoluteChangedCell, this.spreadsheet);
            ((AbstractSeriesData)seriesData).dataUpdateListener.categoryModified(index, cellValue);
        }
    }

    protected String tryGetSeriesName(CTSerTx tx) {
        try {
            if (tx.isSetV()) {
                return tx.getV();
            }
            if (tx.isSetStrRef()) {
                String formula = tx.getStrRef().getF();
                return Utils.getStringValueFromFormula(formula, this.spreadsheet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    protected Double getNumericValueFromCellRef(CellReference cellRef) {
        return Utils.getNumericValue(cellRef, this.getSpreadsheet());
    }

    public static enum ValueUpdateMode {
        Y_VALUES,
        X_VALUES,
        Z_VALUES,
        CATEGORIES;

    }
}

