/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.spreadsheet.framework.ReflectTools;
import com.vaadin.flow.component.spreadsheet.rpc.PopupButtonServerRpc;
import com.vaadin.flow.component.spreadsheet.shared.PopupButtonState;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.poi.ss.util.CellReference;

@Tag(value="div")
public class PopupButton
extends Component {
    private PopupButtonServerRpc rpc = new PopupButtonServerRpc(){

        @Override
        public void onPopupClose() {
            PopupButton.this.fireClose();
        }

        @Override
        public void onPopupButtonClick() {
            PopupButton.this.fireOpen();
        }
    };
    private Component child;
    private PopupButtonState state = new PopupButtonState();

    public PopupButton() {
        this.registerRpc(this.rpc);
    }

    private void registerRpc(PopupButtonServerRpc rpc) {
        this.rpc = rpc;
    }

    public PopupButton(Component content) {
        this();
        this.child = content;
    }

    public CellReference getCellReference() {
        return new CellReference(this.getState().sheet, this.getState().row - 1, this.getState().col - 1, true, true);
    }

    void setCellReference(CellReference cellReference) {
        this.getState().col = cellReference.getCol() + 1;
        this.getState().row = cellReference.getRow() + 1;
        this.getState().sheet = cellReference.getSheetName();
    }

    public int getColumn() {
        return this.getState().col - 1;
    }

    public int getRow() {
        return this.getState().row - 1;
    }

    public void openPopup() {
        this.getElement().appendChild(new Element[]{this.getContent().getElement()});
        this.getParent().ifPresent(parent -> parent.getElement().callJsFunction("onPopupButtonOpen", new Serializable[]{Integer.valueOf(this.getRow() + 1), Integer.valueOf(this.getColumn() + 1), Integer.valueOf(this.getElement().getNode().getId()), UI.getCurrent().getInternals().getAppId()}));
        this.fireOpen();
    }

    public void closePopup() {
        this.getParent().ifPresent(parent -> parent.getElement().callJsFunction("closePopup", new Serializable[]{Integer.valueOf(this.getRow() + 1), Integer.valueOf(this.getColumn() + 1)}));
        this.fireClose();
    }

    public boolean isHeaderHidden() {
        return this.getState().headerHidden;
    }

    public void setHeaderHidden(boolean headerHidden) {
        this.getState().headerHidden = headerHidden;
    }

    public void setPopupWidth(String width) {
        this.getState().popupWidth = width;
    }

    public String getPopupWidth() {
        return this.getState().popupWidth;
    }

    public void setPopupHeight(String height) {
        this.getState().popupHeight = height;
    }

    public String getPopupHeight() {
        return this.getState().popupHeight;
    }

    protected PopupButtonState getState() {
        return this.state;
    }

    public void setContent(Component content) {
        this.child = content;
    }

    public Component getContent() {
        return this.child;
    }

    public void markActive(boolean active) {
        this.getState().active = active;
    }

    public boolean isActive() {
        return this.getState().active;
    }

    public Registration addPopupOpenListener(PopupOpenListener listener) {
        return this.addListener(PopupOpenEvent.class, listener::onPopupOpen);
    }

    public Registration addPopupCloseListener(PopupCloseListener listener) {
        return this.addListener(PopupCloseEvent.class, listener::onPopupClose);
    }

    private void fireOpen() {
        this.fireEvent(new PopupOpenEvent(this));
    }

    private void fireClose() {
        this.fireEvent(new PopupCloseEvent(this));
    }

    public static class PopupOpenEvent
    extends ComponentEvent<Component> {
        public PopupOpenEvent(Component source) {
            super(source, false);
        }

        public PopupButton getPopupButton() {
            return (PopupButton)this.getSource();
        }
    }

    public static interface PopupOpenListener
    extends Serializable {
        public static final Method POPUP_OPEN_METHOD = ReflectTools.findMethod(PopupOpenListener.class, "onPopupOpen", PopupOpenEvent.class);

        public void onPopupOpen(PopupOpenEvent var1);
    }

    public static class PopupCloseEvent
    extends ComponentEvent<Component> {
        public PopupCloseEvent(Component source) {
            super(source, false);
        }

        public PopupButton getPopupButton() {
            return (PopupButton)this.getSource();
        }
    }

    public static interface PopupCloseListener
    extends Serializable {
        public static final Method POPUP_CLOSE_METHOD = ReflectTools.findMethod(PopupCloseListener.class, "onPopupClose", PopupCloseEvent.class);

        public void onPopupClose(PopupCloseEvent var1);
    }
}

