/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.ClientAnchor;

public class SheetImageWrapper
extends SheetOverlayWrapper
implements Serializable {
    private StreamResource resource;
    private DownloadHandler handler;
    private final byte[] data;
    private final String MIMEType;

    public SheetImageWrapper(ClientAnchor anchor, String MIMEType, byte[] data) {
        super(anchor);
        this.MIMEType = MIMEType;
        this.data = data;
    }

    @Override
    @Deprecated(since="24.8", forRemoval=true)
    public StreamResource getResource() {
        if (this.resource == null) {
            this.resource = new StreamResource(this.getId(), (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(this.data));
            this.resource.setContentType(this.MIMEType);
        }
        return this.resource;
    }

    @Override
    public DownloadHandler getResourceHandler() {
        if (this.handler == null) {
            this.handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)downloadEvent -> new DownloadResponse((InputStream)new ByteArrayInputStream(this.data), "download", this.MIMEType, (long)this.data.length)).inline();
        }
        return this.handler;
    }

    @Override
    public OverlayInfo.Type getType() {
        return OverlayInfo.Type.IMAGE;
    }
}

