/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class InsertDeleteCellCommentAction
extends SpreadsheetAction {
    public InsertDeleteCellCommentAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (!spreadsheet.getActiveSheet().getProtect() && event.getCellRangeAddresses().size() == 0 && event.getIndividualSelectedCells().size() == 0) {
            CellReference cr = event.getSelectedCellReference();
            Comment cellComment = spreadsheet.getActiveSheet().getCellComment(new CellAddress(cr.getRow(), (int)cr.getCol()));
            if (cellComment == null) {
                this.setCaption("Insert comment");
            } else {
                this.setCaption("Delete comment");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        Cell cell;
        Sheet sheet = spreadsheet.getActiveSheet();
        CellReference cr = event.getSelectedCellReference();
        boolean cellCreated = false;
        boolean rowCreated = false;
        boolean commentEdited = false;
        Row row = sheet.getRow(cr.getRow());
        if (row == null) {
            row = sheet.createRow(cr.getRow());
            rowCreated = true;
        }
        if ((cell = spreadsheet.getCell(cr)) == null) {
            cell = row.createCell((int)cr.getCol());
            cellCreated = true;
        }
        if (cell.getCellComment() == null) {
            this.createCellComment(spreadsheet, sheet, cell, cr);
            commentEdited = true;
        } else {
            cell.removeCellComment();
            if (cellCreated) {
                sheet.getRow(cr.getRow()).removeCell(cell);
            }
            if (rowCreated) {
                sheet.removeRow(sheet.getRow(cr.getRow()));
            }
        }
        if (cell != null) {
            spreadsheet.refreshCells(cell);
        }
        if (commentEdited) {
            spreadsheet.editCellComment(cr);
        }
    }

    private void createCellComment(Spreadsheet spreadsheet, Sheet sheet, Cell cell, CellReference cellRef) {
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 1);
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + 3);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString("");
        comment.setString(str);
        String author = null;
        if (spreadsheet.getCommentAuthorProvider() != null) {
            author = spreadsheet.getCommentAuthorProvider().getAuthorForComment(cellRef);
        }
        if (author == null || author.trim().isEmpty()) {
            author = "Spreadsheet User";
        }
        comment.setAuthor(author);
        cell.setCellComment(comment);
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Cell comment actions can't be executed against a header range.");
    }
}

