/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;

public class CellValueFormatter
implements Serializable {
    private DecimalFormatSymbols localeDecimalSymbols = DecimalFormatSymbols.getInstance();

    public String getScientificNotationStringForNumericCell(double numericValue, String formattedValue, float cellWidthRatio, int width) {
        BigDecimal ratio = BigDecimal.valueOf(cellWidthRatio);
        BigDecimal columnWidth = BigDecimal.valueOf(width);
        int numberOfDigits = columnWidth.divide(ratio, RoundingMode.DOWN).intValue();
        if (numberOfDigits < 2) {
            return "#";
        }
        int integerPartLength = formattedValue.indexOf(this.localeDecimalSymbols.getDecimalSeparator());
        if (integerPartLength == -1) {
            integerPartLength = formattedValue.length();
        }
        StringBuilder format = new StringBuilder("0");
        if (integerPartLength == formattedValue.length() && numberOfDigits <= 4 && integerPartLength > numberOfDigits) {
            return this.createFillString(numberOfDigits);
        }
        boolean needsScientific = integerPartLength > numberOfDigits || Math.abs(numericValue) < 1.0 && formattedValue.length() > numberOfDigits && numberOfDigits > 4;
        int numberOfDecimals = 0;
        numberOfDecimals = needsScientific ? numberOfDigits - 5 : numberOfDigits - (integerPartLength + 1);
        if (numberOfDecimals > 0) {
            format.append('.');
            for (int i = 0; i < numberOfDecimals; ++i) {
                format.append('#');
            }
        }
        if (needsScientific) {
            format.append("E0");
        }
        if (format.length() > numberOfDigits) {
            return this.createFillString(numberOfDigits);
        }
        return new DecimalFormat(format.toString(), this.localeDecimalSymbols).format(numericValue);
    }

    private String createFillString(int numberOfDigits) {
        char[] filling = new char[numberOfDigits];
        Arrays.fill(filling, '#');
        return new String(filling);
    }

    public void setLocaleDecimalSymbols(DecimalFormatSymbols localeDecimalSymbols) {
        this.localeDecimalSymbols = localeDecimalSymbols;
    }
}

