/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPercentage;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveFixedPercentage;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

class ColorUtils {
    private static Logger logger = Logger.getLogger(ColorUtils.class.getName());
    private static final double ANGLE_FACTOR = 2.16E7;
    private static final float PERCENTAGE_FACTOR = 100000.0f;

    ColorUtils() {
    }

    public static Map<String, byte[]> createColorMap(CTColorScheme clrScheme) {
        HashMap<String, byte[]> colorMap = new HashMap<String, byte[]>();
        if (clrScheme.getDk1().getSysClr() != null) {
            colorMap.put("tx1", clrScheme.getDk1().getSysClr().getLastClr());
            colorMap.put("bg1", clrScheme.getLt1().getSysClr().getLastClr());
        }
        colorMap.put("tx2", clrScheme.getDk2().getSrgbClr().getVal());
        colorMap.put("bg2", clrScheme.getLt2().getSrgbClr().getVal());
        colorMap.put("accent1", clrScheme.getAccent1().getSrgbClr().getVal());
        colorMap.put("accent2", clrScheme.getAccent2().getSrgbClr().getVal());
        colorMap.put("accent3", clrScheme.getAccent3().getSrgbClr().getVal());
        colorMap.put("accent4", clrScheme.getAccent4().getSrgbClr().getVal());
        colorMap.put("accent5", clrScheme.getAccent5().getSrgbClr().getVal());
        colorMap.put("accent6", clrScheme.getAccent6().getSrgbClr().getVal());
        return colorMap;
    }

    public static ChartData.GradientProperties createGradientProperties(CTGradientFillProperties gradFill, Map<String, byte[]> colorMap) {
        ChartData.GradientProperties gradientProp = new ChartData.GradientProperties();
        for (CTGradientStop stop : gradFill.getGsLst().getGsList()) {
            ChartData.ColorProperties stopClrProp = ColorUtils.createColorPropertiesFromGradientStop(stop, colorMap);
            gradientProp.colorStops.put((double)((Integer)stop.getPos()).intValue() / 100000.0, stopClrProp);
        }
        if (gradFill.isSetLin() && gradFill.getLin().isSetAng()) {
            gradientProp.angle = (double)gradFill.getLin().getAng() / 2.16E7;
        }
        return gradientProp;
    }

    public static ChartData.ColorProperties createColorPropertiesFromFill(CTSolidColorFillProperties solidFill, Map<String, byte[]> colorMap) {
        if (solidFill == null) {
            return null;
        }
        ColorParameters clr = null;
        if (solidFill.isSetSchemeClr()) {
            clr = ColorUtils.getParametersFromSchemeClr(solidFill.getSchemeClr(), colorMap);
        } else if (solidFill.isSetSrgbClr()) {
            clr = ColorUtils.getColorParametersFromSrgb(solidFill.getSrgbClr());
        } else {
            logger.warning("Unhandled color fill \n" + solidFill);
            return null;
        }
        return ColorUtils.createColorPropertiesFromParameters(clr);
    }

    private static ColorParameters getParametersFromSchemeClr(CTSchemeColor schemeClr, Map<String, byte[]> colorMap) {
        ColorParameters clr = new ColorParameters();
        String colorName = schemeClr.getVal().toString();
        if (!colorMap.containsKey(colorName)) {
            logger.warning("Color " + colorName + " is not in the color table");
            return null;
        }
        clr.rgb = colorMap.get(colorName);
        clr.lumMod = ColorUtils.getLum(schemeClr.getLumModList());
        clr.lumOff = ColorUtils.getLum(schemeClr.getLumOffList());
        clr.alpha = ColorUtils.getAlpha(schemeClr.getAlphaList());
        return clr;
    }

    private static ChartData.ColorProperties createColorPropertiesFromGradientStop(CTGradientStop gradientStop, Map<String, byte[]> colorMap) {
        if (gradientStop == null) {
            return null;
        }
        ColorParameters clr = null;
        if (gradientStop.isSetSchemeClr()) {
            clr = ColorUtils.getParametersFromSchemeClr(gradientStop.getSchemeClr(), colorMap);
        } else if (gradientStop.isSetSrgbClr()) {
            clr = ColorUtils.getColorParametersFromSrgb(gradientStop.getSrgbClr());
        } else {
            logger.warning("Unhandled color fill \n" + gradientStop);
            return null;
        }
        return ColorUtils.createColorPropertiesFromParameters(clr);
    }

    private static ColorParameters getColorParametersFromSrgb(CTSRgbColor srgbClr) {
        ColorParameters clr = new ColorParameters();
        clr.rgb = srgbClr.getVal();
        clr.lumMod = ColorUtils.getLum(srgbClr.getLumModList());
        clr.lumOff = ColorUtils.getLum(srgbClr.getLumOffList());
        clr.alpha = ColorUtils.getAlpha(srgbClr.getAlphaList());
        return clr;
    }

    private static float getLum(List<CTPercentage> list) {
        if (list.size() > 0) {
            return (float)((Integer)list.get(0).getVal()).intValue() / 100000.0f;
        }
        return 0.0f;
    }

    private static float getAlpha(List<CTPositiveFixedPercentage> alphaList) {
        if (alphaList.size() > 0) {
            return (float)((Integer)alphaList.get(0).getVal()).intValue() / 100000.0f;
        }
        return 1.0f;
    }

    private static ChartData.ColorProperties createColorPropertiesFromParameters(ColorParameters par) {
        if (par == null) {
            return null;
        }
        byte[] rgbWithLum = ColorUtils.applyLum(par.rgb, par.lumMod, par.lumOff);
        int[] rgbUnsignedWithLum = ColorUtils.convertToUnsignedRange(rgbWithLum);
        return new ChartData.ColorProperties(rgbUnsignedWithLum, par.alpha);
    }

    private static int[] convertToUnsignedRange(byte[] signedRange) {
        return new int[]{signedRange[0] & 0xFF, signedRange[1] & 0xFF, signedRange[2] & 0xFF};
    }

    private static byte[] applyLum(byte[] rgb, float lumMod, float lumOff) {
        if (lumMod == 0.0f) {
            return rgb;
        }
        float[] hsl = ColorUtils.toHSL(rgb);
        float lum = hsl[2] / 100.0f;
        float newLum = lum * lumMod + lumOff;
        hsl[2] = newLum * 100.0f;
        return ColorUtils.toRGB(hsl[0], hsl[1], hsl[2]);
    }

    private static float[] toHSL(byte[] rgb) {
        float r = (float)(rgb[0] & 0xFF) / 255.0f;
        float g = (float)(rgb[1] & 0xFF) / 255.0f;
        float b = (float)(rgb[2] & 0xFF) / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = 0.0f;
        s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s * 100.0f, l * 100.0f};
    }

    private static byte[] toRGB(float hue, float sat, float lum) {
        float h = hue % 360.0f;
        h /= 360.0f;
        float s = sat;
        float l = lum;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, ColorUtils.HueToRGB(p, q, h + 0.33333334f));
        float g = Math.max(0.0f, ColorUtils.HueToRGB(p, q, h));
        float b = Math.max(0.0f, ColorUtils.HueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        byte r_byte = (byte)Math.round(r * 255.0f);
        byte g_byte = (byte)Math.round(g * 255.0f);
        byte b_byte = (byte)Math.round(b * 255.0f);
        return new byte[]{r_byte, g_byte, b_byte};
    }

    private static float HueToRGB(float p, float q, float hue) {
        float h = hue;
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    static class ColorParameters {
        public byte[] rgb;
        public float lumMod;
        public float lumOff;
        public float alpha = 1.0f;

        ColorParameters() {
        }
    }
}

