/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.RadarSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.LineSeriesReaderUtils;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTRadarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTRadarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.STRadarStyle;

public class RadarSeriesReader
extends AbstractSeriesReader<CTRadarSer, RadarSeriesData> {
    public RadarSeriesReader(CTRadarChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    @Override
    protected RadarSeriesData createSeriesDataObject(CTRadarSer serie) {
        RadarSeriesData result = new RadarSeriesData();
        CTRadarChart radarChart = (CTRadarChart)this.getChart();
        if (radarChart.getRadarStyle() != null && radarChart.getRadarStyle().getVal() != STRadarStyle.FILLED) {
            result.filled = false;
        }
        return result;
    }

    @Override
    protected void fillSeriesData(RadarSeriesData seriesData, CTRadarSer serie) {
        super.fillSeriesData(seriesData, serie);
        if (serie.getMarker() != null) {
            LineSeriesReaderUtils.setMarkerForData(seriesData, serie.getMarker());
        }
        if (serie.getSpPr() != null) {
            LineSeriesReaderUtils.setDashStyleForData(seriesData, serie.getSpPr());
        }
    }
}

