/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class ShowHideCellCommentAction
extends SpreadsheetAction {
    public ShowHideCellCommentAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (!spreadsheet.getActiveSheet().getProtect() && event.getCellRangeAddresses().size() == 0 && event.getIndividualSelectedCells().size() == 0) {
            CellReference cr = event.getSelectedCellReference();
            Comment cellComment = spreadsheet.getActiveSheet().getCellComment(new CellAddress(cr.getRow(), (int)cr.getCol()));
            if (cellComment != null) {
                if (cellComment.isVisible()) {
                    this.setCaption("Hide comment");
                } else {
                    this.setCaption("Show comment");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        Cell cell;
        Comment cellComment;
        CellReference cr = event.getSelectedCellReference();
        cellComment.setVisible(!(cellComment = spreadsheet.getActiveSheet().getCellComment(new CellAddress(cr.getRow(), (int)cr.getCol()))).isVisible());
        Sheet sheet = spreadsheet.getActiveSheet();
        Row row = sheet.getRow(cr.getRow());
        if (row == null) {
            row = sheet.createRow(cr.getRow());
        }
        if ((cell = spreadsheet.getCell(cr)) == null) {
            cell = row.createCell((int)cr.getCol());
        }
        spreadsheet.refreshCells(cell);
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Hide header action can't be executed against a selection.");
    }
}

