/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class UnHideHeadersAction
extends SpreadsheetAction {
    private int unhideHeaderIndex = 0;

    public UnHideHeadersAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadhseet, Spreadsheet.SelectionChangeEvent event) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        Sheet activeSheet = spreadsheet.getActiveSheet();
        if (this.isSheetProtected(activeSheet)) return false;
        if (headerRange.isFullColumnRange()) {
            int index = headerRange.getFirstColumn();
            if (!activeSheet.isColumnHidden(index)) {
                if (index > 0 && activeSheet.isColumnHidden(index - 1)) {
                    this.setCaption("Unhide column " + this.getColumnHeader(index));
                    this.unhideHeaderIndex = index - 1;
                    return true;
                }
                if (!activeSheet.isColumnHidden(index + 1)) return false;
                this.setCaption("Unhide column " + this.getColumnHeader(index + 2));
                this.unhideHeaderIndex = index + 1;
                return true;
            }
            this.setCaption("Unhide column " + this.getColumnHeader(index + 1));
            this.unhideHeaderIndex = index;
            return true;
        }
        if (!headerRange.isFullRowRange()) return false;
        int index = headerRange.getFirstRow();
        if (!spreadsheet.isRowHidden(index)) {
            if (index > 0 && spreadsheet.isRowHidden(index - 1)) {
                this.setCaption("Unhide row " + index);
                this.unhideHeaderIndex = index - 1;
                return true;
            }
            if (!spreadsheet.isRowHidden(index + 1)) return false;
            this.setCaption("Unhide row " + (index + 2));
            this.unhideHeaderIndex = index + 1;
            return true;
        }
        this.setCaption("Unhide row " + (index + 1));
        this.unhideHeaderIndex = index;
        return true;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        throw new UnsupportedOperationException("Show row/column action can't be executed against a selection.");
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        if (headerRange.isFullColumnRange()) {
            spreadsheet.setColumnHidden(this.unhideHeaderIndex, false);
        } else if (headerRange.isFullRowRange()) {
            spreadsheet.setRowHidden(this.unhideHeaderIndex, false);
        }
    }
}

