/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.PlotOptionsArea;
import com.vaadin.flow.component.charts.model.Stacking;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AreaSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.AbstractSeriesDataWriter;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.LineSeriesWriterUtils;

public class AreaSeriesDataWriter
extends AbstractSeriesDataWriter {
    public AreaSeriesDataWriter(AreaSeriesData series) {
        super(series);
    }

    @Override
    protected AreaSeriesData getSeriesData() {
        return (AreaSeriesData)super.getSeriesData();
    }

    protected PlotOptionsArea getPlotOptions() {
        return (PlotOptionsArea)super.getPlotOptions();
    }

    @Override
    protected AbstractPlotOptions createPlotOptions() {
        return new PlotOptionsArea();
    }

    @Override
    protected void configureDataSeries(DataSeries dataSeriesForWriting) {
        super.configureDataSeries(dataSeriesForWriting);
        String stacking = this.getSeriesData().stacking.toString();
        this.getPlotOptions().setStacking(Utils.getEnumValueOrDefault(Stacking.class, stacking, Stacking.NONE));
        this.getPlotOptions().setDashStyle(LineSeriesWriterUtils.getDashStyle(this.getSeriesData().dashStyle));
        this.getPlotOptions().setMarker(LineSeriesWriterUtils.getMarker(this.getSeriesData().markerSymbol));
    }
}

