/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.PlotOptionsPie;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.PieSeriesData;

public class PieToDonutConverter {
    private static final double DONUT_GAP_BETWEEN_RINGS = 0.02;

    public static void convertIfNeeded(ChartData definition, Configuration conf) {
        if (definition.plotData.size() > 0 && definition.plotData.get(0) instanceof PieSeriesData) {
            PieSeriesData pieSeriesData = (PieSeriesData)definition.plotData.get(0);
            if (pieSeriesData.isDonut) {
                PieToDonutConverter.convertPieToDonut(conf, pieSeriesData.donutHoleSizePercent);
            }
        }
    }

    private static void convertPieToDonut(Configuration conf, short donutHoleSizePercent) {
        int pieSerCount = PieToDonutConverter.countPieSeries(conf);
        int currentPieSeries = 0;
        double onePieShare = (1.0 - (double)donutHoleSizePercent / 100.0) / (double)pieSerCount;
        double gap = 0.02;
        for (Series ser : conf.getSeries()) {
            if (!ChartType.PIE.equals((Object)ser.getPlotOptions().getChartType())) continue;
            double currentShare = 1.0 - (double)currentPieSeries * onePieShare;
            double innerSize = (currentShare - onePieShare + 0.02) / currentShare;
            ((PlotOptionsPie)ser.getPlotOptions()).setInnerSize(Math.round(innerSize * 100.0) + "%");
            ((PlotOptionsPie)ser.getPlotOptions()).setSize(Math.round(currentShare * 100.0) + "%");
            ++currentPieSeries;
        }
    }

    private static int countPieSeries(Configuration conf) {
        int count = 0;
        for (Series ser : conf.getSeries()) {
            if (!ChartType.PIE.equals((Object)ser.getPlotOptions().getChartType())) continue;
            ++count;
        }
        return count;
    }
}

