/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.PlotOptionsScatter;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ScatterSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.AbstractSeriesDataWriter;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.LineSeriesWriterUtils;

public class ScatterSeriesDataWriter
extends AbstractSeriesDataWriter {
    private static final int SCATTER_LINE_WIDTH = 2;

    public ScatterSeriesDataWriter(ScatterSeriesData series) {
        super(series);
    }

    @Override
    protected ScatterSeriesData getSeriesData() {
        return (ScatterSeriesData)super.getSeriesData();
    }

    protected PlotOptionsScatter createPlotOptions() {
        return new PlotOptionsScatter();
    }

    protected PlotOptionsScatter getPlotOptions() {
        return (PlotOptionsScatter)super.getPlotOptions();
    }

    @Override
    protected void configureDataSeries(DataSeries dataSeriesForWriting) {
        super.configureDataSeries(dataSeriesForWriting);
        if (this.getSeriesData().lineWidth != null) {
            this.getPlotOptions().setLineWidth((Number)this.getSeriesData().lineWidth);
        } else {
            this.getPlotOptions().setLineWidth((Number)2);
        }
        this.getPlotOptions().setDashStyle(LineSeriesWriterUtils.getDashStyle(this.getSeriesData().dashStyle));
        if (!this.getSeriesData().markerSymbol.isEmpty()) {
            this.getPlotOptions().setMarker(LineSeriesWriterUtils.getMarker(this.getSeriesData().markerSymbol));
        }
    }
}

