/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import org.apache.poi.ss.formula.EvaluationCache;
import org.apache.poi.ss.formula.EvaluationTracker;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.BaseXSSFFormulaEvaluator;

public class WorkbookEvaluatorUtil {
    public static ValueEval evaluate(Spreadsheet spreadsheet, Ptg[] ptgs, Cell cell) {
        WorkbookEvaluator workbookEvaluator = ((BaseXSSFFormulaEvaluator)spreadsheet.getFormulaEvaluator())._getWorkbookEvaluator();
        OperationEvaluationContext ec = new OperationEvaluationContext(workbookEvaluator, workbookEvaluator.getWorkbook(), WorkbookEvaluatorUtil.getSheetIndex(cell), cell.getRowIndex(), cell.getColumnIndex(), new EvaluationTracker(new EvaluationCache(null)));
        return workbookEvaluator.evaluateFormula(ec, ptgs);
    }

    public static BaseXSSFEvaluationWorkbook getEvaluationWorkbook(Spreadsheet spreadsheet) {
        return (BaseXSSFEvaluationWorkbook)((BaseXSSFFormulaEvaluator)spreadsheet.getFormulaEvaluator())._getWorkbookEvaluator().getWorkbook();
    }

    private static int getSheetIndex(Cell cell) {
        Sheet sheet = cell.getSheet();
        return sheet.getWorkbook().getSheetIndex(sheet);
    }
}

