/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.ColorConverter;
import com.vaadin.flow.component.spreadsheet.HSSFColorConverter;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetStyleFactory;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.XSSFColorConverter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.WorkbookEvaluatorUtil;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.usermodel.BorderFormatting;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ConditionType;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFBorderFormatting;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFFontFormatting;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBooleanProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalFormatter
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionalFormatter.class);
    private static String BORDER_STYLE_DEFAULT = "1pt solid #d6d6d6;";
    private Spreadsheet spreadsheet;
    private Map<String, Set<Integer>> cellToIndex = new HashMap<String, Set<Integer>>();
    private Map<ConditionalFormatting, Integer> topBorders = new HashMap<ConditionalFormatting, Integer>();
    private Map<ConditionalFormatting, Integer> leftBorders = new HashMap<ConditionalFormatting, Integer>();
    protected ColorConverter colorConverter;

    public ConditionalFormatter(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        Workbook workbook = spreadsheet.getWorkbook();
        this.colorConverter = workbook instanceof HSSFWorkbook ? new HSSFColorConverter((HSSFWorkbook)workbook) : new XSSFColorConverter((XSSFWorkbook)workbook);
    }

    public Set<Integer> getCellFormattingIndex(Cell cell) {
        Set<Integer> index = this.cellToIndex.get(SpreadsheetUtil.toKey(cell));
        return index;
    }

    public void createConditionalFormatterRules() {
        if (this.cellToIndex != null) {
            for (String key : this.cellToIndex.keySet()) {
                int col = SpreadsheetUtil.getColumnIndexFromKey(key) - 1;
                int row = SpreadsheetUtil.getRowFromKey(key) - 1;
                Cell cell = this.spreadsheet.getCell(row, col);
                if (cell == null) continue;
                this.spreadsheet.markCellAsUpdated(cell, true);
            }
        }
        this.cellToIndex.clear();
        this.topBorders.clear();
        this.leftBorders.clear();
        HashMap<Integer, String> conditionalFormattingStyles = new HashMap<Integer, String>();
        SheetConditionalFormatting cfs = this.spreadsheet.getActiveSheet().getSheetConditionalFormatting();
        if (cfs instanceof HSSFSheetConditionalFormatting) {
            return;
        }
        block1: for (int i = 0; i < cfs.getNumConditionalFormattings(); ++i) {
            ConditionalFormatting cf = cfs.getConditionalFormattingAt(i);
            List<XSSFConditionalFormattingRule> cfRuleList = this.getOrderedRuleList(cf);
            for (int ruleIndex = cf.getNumberOfRules() - 1; ruleIndex >= 0; --ruleIndex) {
                String colorCSS;
                PatternFormatting patternFormatting;
                ConditionalFormattingRule rule = (ConditionalFormattingRule)cfRuleList.get(ruleIndex);
                int cssIndex = i * 1000000 + ruleIndex * 1000;
                StringBuilder css = new StringBuilder();
                FontFormatting fontFormatting = rule.getFontFormatting();
                if (fontFormatting != null) {
                    String fontColorCSS = this.colorConverter.getFontColorCSS(rule);
                    if (fontColorCSS != null) {
                        css.append("color:" + fontColorCSS);
                    }
                    if (fontFormatting.getUnderlineType() != 0 && fontFormatting.getUnderlineType() != 255) {
                        css.append("text-decoration: underline;");
                    }
                    if (this.hasStrikeThrough(fontFormatting)) {
                        css.append("text-decoration: line-through;");
                    }
                    if (fontFormatting.getFontHeight() != -1) {
                        int fontHeight = fontFormatting.getFontHeight() / 20;
                        css.append("font-size:" + fontHeight + "pt;");
                    }
                    if (fontFormatting.isItalic() && fontFormatting.isBold()) {
                        css.append("font-style: italic;");
                        css.append("font-weight: bold;");
                    } else if (fontFormatting.isItalic()) {
                        css.append("font-style: italic;");
                        css.append("font-weight: initial;");
                    } else if (fontFormatting.isBold()) {
                        css.append("font-style: normal;");
                        css.append("font-weight: bold;");
                    }
                }
                if ((patternFormatting = rule.getPatternFormatting()) != null && (colorCSS = this.colorConverter.getBackgroundColorCSS(rule)) != null) {
                    css.append("background-color:" + colorCSS);
                }
                cssIndex = this.addBorderFormatting(cf, rule, css, cssIndex, conditionalFormattingStyles);
                conditionalFormattingStyles.put(cssIndex, css.toString());
                this.runCellMatcher(cf, rule, cssIndex);
                if (this.stopHere(rule)) continue block1;
            }
        }
        this.spreadsheet.setConditionalFormattingStyles(conditionalFormattingStyles);
    }

    protected FormulaEvaluator getFormulaEvaluator() {
        return this.spreadsheet.getFormulaEvaluator();
    }

    private List<XSSFConditionalFormattingRule> getOrderedRuleList(ConditionalFormatting cf) {
        XSSFConditionalFormatting xcf = (XSSFConditionalFormatting)cf;
        ArrayList<XSSFConditionalFormattingRule> rules = new ArrayList<XSSFConditionalFormattingRule>();
        for (int i = 0; i < xcf.getNumberOfRules(); ++i) {
            rules.add(xcf.getRule(i));
        }
        Collections.sort(rules, new Comparator<XSSFConditionalFormattingRule>(){

            @Override
            public int compare(XSSFConditionalFormattingRule o1, XSSFConditionalFormattingRule o2) {
                CTCfRule object = (CTCfRule)ConditionalFormatter.this.getFieldValWithReflection(o1, "_cfRule");
                CTCfRule object2 = (CTCfRule)ConditionalFormatter.this.getFieldValWithReflection(o2, "_cfRule");
                if (object != null && object2 != null) {
                    return object2.getPriority() - object.getPriority();
                }
                return 0;
            }
        });
        return rules;
    }

    private int addBorderFormatting(ConditionalFormatting cf, ConditionalFormattingRule rule, StringBuilder css, int cssIndex, HashMap<Integer, String> conditionalFormattingStyles) {
        if (!(rule instanceof XSSFConditionalFormattingRule)) {
            return cssIndex;
        }
        XSSFBorderFormatting borderFormatting = (XSSFBorderFormatting)rule.getBorderFormatting();
        if (borderFormatting != null) {
            StringBuilder sb2;
            SpreadsheetStyleFactory.BorderStyle borderLeft = SpreadsheetStyleFactory.BORDER.get(borderFormatting.getBorderLeft());
            SpreadsheetStyleFactory.BorderStyle borderRight = SpreadsheetStyleFactory.BORDER.get(borderFormatting.getBorderRight());
            SpreadsheetStyleFactory.BorderStyle borderTop = SpreadsheetStyleFactory.BORDER.get(borderFormatting.getBorderTop());
            SpreadsheetStyleFactory.BorderStyle borderBottom = SpreadsheetStyleFactory.BORDER.get(borderFormatting.getBorderBottom());
            boolean isLeftSet = this.isBorderSet(borderFormatting, XSSFCellBorder.BorderSide.LEFT);
            boolean isTopSet = this.isBorderSet(borderFormatting, XSSFCellBorder.BorderSide.TOP);
            boolean isRightSet = this.isBorderSet(borderFormatting, XSSFCellBorder.BorderSide.RIGHT);
            boolean isBottomSet = this.isBorderSet(borderFormatting, XSSFCellBorder.BorderSide.BOTTOM);
            if (isRightSet) {
                css.append("border-right:");
                if (borderRight != SpreadsheetStyleFactory.BorderStyle.NONE) {
                    css.append(borderRight.getBorderAttributeValue());
                    css.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.RIGHT, "border-right-color", (BorderFormatting)borderFormatting));
                } else {
                    css.append(BORDER_STYLE_DEFAULT);
                }
            }
            if (isBottomSet) {
                css.append("border-bottom:");
                if (borderBottom != SpreadsheetStyleFactory.BorderStyle.NONE) {
                    css.append(borderBottom.getBorderAttributeValue());
                    css.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.BOTTOM, "border-bottom-color", (BorderFormatting)borderFormatting));
                } else {
                    css.append(BORDER_STYLE_DEFAULT);
                }
            }
            if (isTopSet) {
                sb2 = new StringBuilder("border-bottom:");
                if (borderTop != SpreadsheetStyleFactory.BorderStyle.NONE) {
                    sb2.append(borderTop.getBorderAttributeValue());
                    sb2.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.TOP, "border-bottom-color", (BorderFormatting)borderFormatting));
                    conditionalFormattingStyles.put(cssIndex, sb2.toString());
                    this.topBorders.put(cf, cssIndex++);
                } else {
                    css.append(BORDER_STYLE_DEFAULT);
                }
            }
            if (isLeftSet) {
                sb2 = new StringBuilder("border-right:");
                if (borderLeft != SpreadsheetStyleFactory.BorderStyle.NONE) {
                    sb2.append(borderLeft.getBorderAttributeValue());
                    sb2.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.LEFT, "border-right-color", (BorderFormatting)borderFormatting));
                    conditionalFormattingStyles.put(cssIndex, sb2.toString());
                    this.leftBorders.put(cf, cssIndex++);
                } else {
                    css.append(BORDER_STYLE_DEFAULT);
                }
            }
        }
        return cssIndex;
    }

    private boolean stopHere(ConditionalFormattingRule rule) {
        CTCfRule ctRule;
        if (rule instanceof XSSFConditionalFormattingRule && (ctRule = (CTCfRule)this.getFieldValWithReflection(rule, "_cfRule")) != null) {
            return ctRule.getStopIfTrue();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValWithReflection(Object owner, String fieldName) {
        Field f = null;
        Object val = null;
        try {
            f = owner.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            Object object = val = f.get(owner);
            return object;
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Incompatible POI implementation, unable to parse conditional formatting rule", (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error("Incompatible POI implementation, unable to parse conditional formatting rule", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Incompatible POI implementation, unable to parse conditional formatting rule", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Incompatible POI implementation, unable to parse conditional formatting rule", (Throwable)e);
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
        return null;
    }

    private boolean isBorderSet(XSSFBorderFormatting borderFormatting, XSSFCellBorder.BorderSide b) {
        CTBorder ctBorder = (CTBorder)this.getFieldValWithReflection(borderFormatting, "_border");
        if (ctBorder == null) {
            return false;
        }
        switch (b) {
            case LEFT: {
                return ctBorder.isSetLeft();
            }
            case TOP: {
                return ctBorder.isSetTop();
            }
            case RIGHT: {
                return ctBorder.isSetRight();
            }
            case BOTTOM: {
                return ctBorder.isSetBottom();
            }
            case DIAGONAL: {
                return ctBorder.isSetDiagonal();
            }
            case HORIZONTAL: {
                return ctBorder.isSetHorizontal();
            }
            case VERTICAL: {
                return ctBorder.isSetVertical();
            }
        }
        return false;
    }

    private boolean hasStrikeThrough(FontFormatting fontFormatting) {
        if (fontFormatting instanceof XSSFFontFormatting) {
            CTFont font = (CTFont)this.getFieldValWithReflection(fontFormatting, "_font");
            if (font == null) {
                return false;
            }
            List strikeList = font.getStrikeList();
            if (strikeList != null) {
                for (CTBooleanProperty p : strikeList) {
                    if (!p.getVal()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void runCellMatcher(ConditionalFormatting cf, ConditionalFormattingRule rule, int classNameIndex) {
        int firstColumn = cf.getFormattingRanges()[0].getFirstColumn();
        int firstRow = cf.getFormattingRanges()[0].getFirstRow();
        for (CellRangeAddress cra : cf.getFormattingRanges()) {
            for (int row = cra.getFirstRow(); row <= cra.getLastRow(); ++row) {
                for (int col = cra.getFirstColumn(); col <= cra.getLastColumn(); ++col) {
                    int ruleIndex;
                    Cell cell = this.spreadsheet.getCell(row, col);
                    if (cell == null) {
                        cell = this.spreadsheet.createCell(row, col, "");
                    }
                    if (!this.matches(cell, rule, col - firstColumn, row - firstRow)) continue;
                    Set<Integer> list = this.cellToIndex.get(SpreadsheetUtil.toKey(cell));
                    if (list == null) {
                        list = new HashSet<Integer>();
                        this.cellToIndex.put(SpreadsheetUtil.toKey(cell), list);
                    }
                    list.add(classNameIndex);
                    if (this.leftBorders.containsKey(cf)) {
                        ruleIndex = this.leftBorders.get(cf);
                        if (col != 0) {
                            Cell cellToLeft = this.spreadsheet.getCell(row, col - 1);
                            if (cellToLeft == null) {
                                cellToLeft = this.spreadsheet.createCell(row, col - 1, "");
                            }
                            if ((list = this.cellToIndex.get(SpreadsheetUtil.toKey(cellToLeft))) == null) {
                                list = new HashSet<Integer>();
                                this.cellToIndex.put(SpreadsheetUtil.toKey(cellToLeft), list);
                            }
                            list.add(ruleIndex);
                        }
                    }
                    if (!this.topBorders.containsKey(cf)) continue;
                    ruleIndex = this.topBorders.get(cf);
                    if (row == 0) continue;
                    Cell cellOnTop = this.spreadsheet.getCell(row - 1, col);
                    if (cellOnTop == null) {
                        cellOnTop = this.spreadsheet.createCell(row - 1, col, "");
                    }
                    if ((list = this.cellToIndex.get(SpreadsheetUtil.toKey(cellOnTop))) == null) {
                        list = new HashSet<Integer>();
                        this.cellToIndex.put(SpreadsheetUtil.toKey(cellOnTop), list);
                    }
                    list.add(ruleIndex);
                }
            }
        }
    }

    protected boolean matches(Cell cell, ConditionalFormattingRule rule, int deltaColumn, int deltaRow) {
        try {
            if (rule.getConditionType().equals(ConditionType.CELL_VALUE_IS)) {
                return this.matchesValue(cell, rule, deltaColumn, deltaRow);
            }
            return this.matchesFormula(cell, rule, deltaColumn, deltaRow);
        }
        catch (NotImplementedException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean matchesFormula(Cell cell, ConditionalFormattingRule rule, int deltaColumn, int deltaRow) {
        if (!(rule instanceof XSSFConditionalFormattingRule)) {
            return false;
        }
        String booleanFormula = rule.getFormula1();
        if (booleanFormula == null || booleanFormula.isEmpty()) {
            return false;
        }
        ValueEval eval = this.getValueEvalFromFormula(booleanFormula, cell, deltaColumn, deltaRow);
        if (eval instanceof ErrorEval) {
            LOGGER.trace(((ErrorEval)eval).getErrorString(), (Object)eval);
        }
        if (eval instanceof BoolEval) {
            return ((BoolEval)eval).getBooleanValue();
        }
        if (eval instanceof NumberEval) {
            return ((NumberEval)eval).getNumberValue() != 0.0;
        }
        return false;
    }

    private ValueEval getValueEvalFromFormula(String formula, Cell cell, int deltaColumn, int deltaRow) {
        Ptg[] ptgs;
        for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)WorkbookEvaluatorUtil.getEvaluationWorkbook(this.spreadsheet), (FormulaType)FormulaType.CELL, (int)this.spreadsheet.getActiveSheetIndex())) {
            if (!(ptg instanceof RefPtgBase)) continue;
            RefPtgBase ref = (RefPtgBase)ptg;
            if (ref.isColRelative()) {
                ref.setColumn(ref.getColumn() + deltaColumn);
            }
            if (!ref.isRowRelative()) continue;
            ref.setRow(ref.getRow() + deltaRow);
        }
        return WorkbookEvaluatorUtil.evaluate(this.spreadsheet, ptgs, cell);
    }

    protected boolean matchesValue(Cell cell, ConditionalFormattingRule rule, int deltaColumn, int deltaRow) {
        boolean isFormulaType;
        boolean bl = isFormulaType = cell.getCellType() == CellType.FORMULA;
        if (isFormulaType) {
            this.getFormulaEvaluator().evaluateFormulaCell(cell);
        }
        boolean isFormulaStringType = isFormulaType && cell.getCachedFormulaResultType() == CellType.STRING;
        boolean isFormulaBooleanType = isFormulaType && cell.getCachedFormulaResultType() == CellType.BOOLEAN;
        boolean isFormulaNumericType = isFormulaType && cell.getCachedFormulaResultType() == CellType.NUMERIC;
        String formula = rule.getFormula1();
        byte comparisonOperation = rule.getComparisonOperation();
        ValueEval eval = this.getValueEvalFromFormula(formula, cell, deltaColumn, deltaRow);
        if (eval instanceof ErrorEval) {
            LOGGER.trace(((ErrorEval)eval).getErrorString(), (Object)eval);
            return false;
        }
        if (!this.hasCoherentType(eval, cell.getCellType(), isFormulaStringType, isFormulaBooleanType, isFormulaNumericType)) {
            return comparisonOperation == 4;
        }
        if (eval instanceof StringEval && (cell.getCellType() == CellType.STRING || isFormulaStringType)) {
            String formulaValue = ((StringEval)eval).getStringValue();
            String stringValue = cell.getStringCellValue();
            switch (comparisonOperation) {
                case 3: {
                    return stringValue.equalsIgnoreCase(formulaValue);
                }
                case 4: {
                    return !stringValue.equalsIgnoreCase(formulaValue);
                }
            }
        }
        if (eval instanceof BoolEval && (cell.getCellType() == CellType.BOOLEAN || isFormulaBooleanType)) {
            boolean formulaVal = ((BoolEval)eval).getBooleanValue();
            switch (comparisonOperation) {
                case 3: {
                    return cell.getBooleanCellValue() == formulaVal;
                }
                case 4: {
                    return cell.getBooleanCellValue() != formulaVal;
                }
            }
        }
        if (cell.getCellType() == CellType.NUMERIC || isFormulaNumericType) {
            double formula1Val = ((NumericValueEval)eval).getNumberValue();
            switch (comparisonOperation) {
                case 3: {
                    return cell.getNumericCellValue() == formula1Val;
                }
                case 4: {
                    return cell.getNumericCellValue() != formula1Val;
                }
                case 6: {
                    return cell.getNumericCellValue() < formula1Val;
                }
                case 8: {
                    return cell.getNumericCellValue() <= formula1Val;
                }
                case 5: {
                    return cell.getNumericCellValue() > formula1Val;
                }
                case 7: {
                    return cell.getNumericCellValue() >= formula1Val;
                }
                case 1: {
                    boolean lt = cell.getNumericCellValue() >= formula1Val;
                    boolean gt = cell.getNumericCellValue() <= Double.valueOf(rule.getFormula2());
                    return lt && gt;
                }
                case 2: {
                    boolean lt = cell.getNumericCellValue() <= formula1Val;
                    boolean gt = cell.getNumericCellValue() >= Double.valueOf(rule.getFormula2());
                    return lt && gt;
                }
            }
        }
        return false;
    }

    private boolean hasCoherentType(ValueEval eval, CellType cellType, boolean isFormulaStringType, boolean isFormulaBooleanType, boolean isFormulaNumericType) {
        switch (cellType) {
            case STRING: {
                return eval instanceof StringEval;
            }
            case BOOLEAN: {
                return eval instanceof BoolEval;
            }
            case NUMERIC: {
                return eval instanceof NumericValueEval || isFormulaNumericType;
            }
            case FORMULA: {
                return this.isCoherentTypeFormula(eval, isFormulaStringType, isFormulaBooleanType, isFormulaNumericType);
            }
        }
        return false;
    }

    private boolean isCoherentTypeFormula(ValueEval eval, boolean isFormulaStringType, boolean isFormulaBooleanType, boolean isFormulaNumericType) {
        boolean coherentString = eval instanceof StringEval && isFormulaStringType;
        boolean coherentBoolean = eval instanceof BoolEval && isFormulaBooleanType;
        boolean coherentNumeric = eval instanceof NumericValueEval && isFormulaNumericType;
        return coherentString || coherentBoolean || coherentNumeric;
    }
}

