/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;
import org.apache.poi.ss.util.CellReference;

public class DeleteTableAction
extends SpreadsheetAction {
    protected SpreadsheetTable tableToDelete;

    public DeleteTableAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (!spreadsheet.getActiveSheet().getProtect() && event.getIndividualSelectedCells().size() == 0) {
            if (event.getCellRangeAddresses().size() == 1) {
                List<CellRangeAddress> cras = event.getCellRangeAddresses();
                CellRangeAddress cra = cras.get(0);
                List<SpreadsheetTable> tablesForActiveSheet = spreadsheet.getTablesForActiveSheet();
                for (SpreadsheetTable table : tablesForActiveSheet) {
                    if (CellRangeUtil.intersect((CellRangeAddress)cra, (CellRangeAddress)table.getFullTableRegion()) == 1) continue;
                    this.setCaption("Delete Table " + table.getFullTableRegion().formatAsString());
                    this.tableToDelete = table;
                    return true;
                }
            } else {
                CellReference selectedCellReference = event.getSelectedCellReference();
                List<SpreadsheetTable> tablesForActiveSheet = spreadsheet.getTablesForActiveSheet();
                for (SpreadsheetTable table : tablesForActiveSheet) {
                    if (!table.getFullTableRegion().isInRange(selectedCellReference.getRow(), (int)selectedCellReference.getCol())) continue;
                    this.setCaption("Delete Table " + table.getFullTableRegion().formatAsString());
                    this.tableToDelete = table;
                    return true;
                }
            }
        }
        this.tableToDelete = null;
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (this.tableToDelete != null) {
            spreadsheet.deleteTable(this.tableToDelete);
            this.tableToDelete = null;
        }
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Delete table action can't be executed against a header range.");
    }
}

