/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.command.CellValueCommand;
import com.vaadin.flow.component.spreadsheet.rpc.SpreadsheetServerRpc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class SpreadsheetHandlerImpl
implements SpreadsheetServerRpc {
    private Spreadsheet spreadsheet;

    public SpreadsheetHandlerImpl(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    @Override
    public void onSheetScroll(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        this.spreadsheet.onSheetScroll(firstRow, firstColumn, lastRow, lastColumn);
    }

    @Override
    public void cellSelected(int row, int column, boolean discardOldRangeSelection) {
        this.spreadsheet.getCellSelectionManager().onCellSelected(row, column, discardOldRangeSelection);
    }

    @Override
    public void sheetAddressChanged(String value) {
        this.spreadsheet.getCellSelectionManager().onSheetAddressChanged(value, false);
    }

    @Override
    public void cellRangeSelected(int row1, int col1, int row2, int col2) {
        this.spreadsheet.getCellSelectionManager().onCellRangeSelected(row1, col1, row2, col2);
    }

    @Override
    public void cellRangePainted(int selectedCellRow, int selectedCellColumn, int row1, int col1, int row2, int col2) {
        this.spreadsheet.getCellSelectionManager().onCellRangePainted(selectedCellRow, selectedCellColumn, row1, col1, row2, col2);
    }

    @Override
    public void cellAddedToSelectionAndSelected(int row, int column) {
        this.spreadsheet.getCellSelectionManager().onCellAddToSelectionAndSelected(row, column);
    }

    @Override
    public void cellsAddedToRangeSelection(int row1, int col1, int row2, int col2) {
        this.spreadsheet.getCellSelectionManager().onCellsAddedToRangeSelection(row1, col1, row2, col2);
    }

    @Override
    public void rowSelected(int row, int firstColumnIndex) {
        this.spreadsheet.getCellSelectionManager().onRowSelected(row, firstColumnIndex);
    }

    @Override
    public void rowAddedToRangeSelection(int row, int firstColumnIndex) {
        this.spreadsheet.getCellSelectionManager().onRowAddedToRangeSelection(row, firstColumnIndex);
    }

    @Override
    public void columnSelected(int col, int firstRowIndex) {
        this.spreadsheet.getCellSelectionManager().onColumnSelected(firstRowIndex, col);
    }

    @Override
    public void columnAddedToSelection(int firstRowIndex, int column) {
        this.spreadsheet.getCellSelectionManager().onColumnAddedToSelection(firstRowIndex, column);
    }

    @Override
    public void selectionIncreasePainted(int r1, int c1, int r2, int c2) {
        this.spreadsheet.getCellShifter().onSelectionIncreasePainted(r1, c1, r2, c2);
    }

    @Override
    public void selectionDecreasePainted(int r, int c) {
        this.spreadsheet.getCellShifter().onSelectionDecreasePainted(r, c);
    }

    @Override
    public void cellValueEdited(int row, int col, String value) {
        this.spreadsheet.getCellValueManager().onCellValueChange(col, row, value);
    }

    @Override
    public void sheetSelected(int tabIndex, int scrollLeft, int scrollTop) {
        this.spreadsheet.onSheetSelected(tabIndex, scrollLeft, scrollTop);
    }

    @Override
    public void sheetRenamed(int sheetIndex, String sheetName) {
        this.spreadsheet.onSheetRename(sheetIndex, sheetName);
    }

    @Override
    public void sheetCreated(int scrollLeft, int scrollTop) {
        this.spreadsheet.onNewSheetCreated(scrollLeft, scrollTop);
    }

    @Override
    public void deleteSelectedCells() {
        this.spreadsheet.getCellValueManager().onDeleteSelectedCells();
    }

    @Override
    public void linkCellClicked(int row, int column) {
        this.spreadsheet.onLinkCellClick(row, column);
    }

    @Override
    public void contextMenuOpenOnSelection(int row, int column) {
        this.spreadsheet.getContextMenuManager().onContextMenuOpenOnSelection(row, column);
    }

    @Override
    public void rowHeaderContextMenuOpen(int rowIndex) {
        this.spreadsheet.getContextMenuManager().onRowHeaderContextMenuOpen(rowIndex);
    }

    @Override
    public void columnHeaderContextMenuOpen(int columnIndex) {
        this.spreadsheet.getContextMenuManager().onColumnHeaderContextMenuOpen(columnIndex);
    }

    @Override
    public void actionOnCurrentSelection(String actionKey) {
        this.spreadsheet.getContextMenuManager().onActionOnCurrentSelection(actionKey);
    }

    @Override
    public void actionOnRowHeader(String actionKey) {
        this.spreadsheet.getContextMenuManager().onActionOnRowHeader(actionKey);
    }

    @Override
    public void actionOnColumnHeader(String actionKey) {
        this.spreadsheet.getContextMenuManager().onActionOnColumnHeader(actionKey);
    }

    @Override
    public void rowsResized(Map<Integer, Float> newRowSizes, int row1, int col1, int row2, int col2) {
        this.spreadsheet.onRowResized(newRowSizes, row1, col1, row2, col2);
    }

    @Override
    public void columnResized(Map<Integer, Integer> newColumnSizes, int row1, int col1, int row2, int col2) {
        this.spreadsheet.onColumnResized(newColumnSizes, row1, col1, row2, col2);
    }

    @Override
    public void onRowAutofit(int rowIndex) {
        this.spreadsheet.onRowHeaderDoubleClick(rowIndex - 1);
    }

    @Override
    public void onColumnAutofit(int columnIndex) {
        this.spreadsheet.onColumnAutofit(columnIndex - 1);
    }

    @Override
    public void onUndo() {
        this.spreadsheet.getSpreadsheetHistoryManager().undo();
    }

    @Override
    public void onRedo() {
        this.spreadsheet.getSpreadsheetHistoryManager().redo();
    }

    @Override
    public void setCellStyleWidthRatios(HashMap<Integer, Float> cellStyleWidthRatioMap) {
        this.spreadsheet.getCellValueManager().onCellStyleWidthRatioUpdate(cellStyleWidthRatioMap);
    }

    @Override
    public void onConnectorInit() {
        this.spreadsheet.onConnectorInit();
    }

    @Override
    public void protectedCellWriteAttempted() {
        this.spreadsheet.fireEvent(new Spreadsheet.ProtectedEditEvent(this.spreadsheet));
    }

    @Override
    public void onPaste(String text) {
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activesheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        CellReference selectedCellReference = this.spreadsheet.getSelectedCellReference();
        String[] lines = text.indexOf("\r\n") > -1 ? text.split("\r\n") : (text.indexOf("\n") > -1 ? text.split("\n") : text.split("\r"));
        int pasteHeight = lines.length;
        int pasteWidth = 1;
        for (String line : lines) {
            String[] tokens = SpreadsheetHandlerImpl.splitOnTab(line);
            pasteWidth = Math.max(pasteWidth, tokens.length);
        }
        int rowIndex = selectedCellReference.getRow();
        short colIndex = selectedCellReference.getCol();
        for (int i = 0; i < pasteHeight; ++i) {
            Row row = activesheet.getRow(rowIndex + i);
            if (row == null) continue;
            for (int j = 0; j < pasteWidth; ++j) {
                Cell cell = row.getCell(colIndex + j);
                if (!this.spreadsheet.isCellLocked(cell)) continue;
                this.protectedCellWriteAttempted();
                return;
            }
        }
        CellValueCommand command = new CellValueCommand(this.spreadsheet);
        CellRangeAddress affectedRange = new CellRangeAddress(rowIndex, rowIndex + pasteHeight - 1, (int)colIndex, colIndex + pasteWidth - 1);
        command.captureCellRangeValues(affectedRange);
        for (int i = 0; i < pasteHeight; ++i) {
            String line = lines[i];
            Row row = activesheet.getRow(rowIndex + i);
            if (row == null) {
                row = activesheet.createRow(rowIndex + i);
            }
            String[] tokens = SpreadsheetHandlerImpl.splitOnTab(line);
            for (int j = 0; j < pasteWidth; ++j) {
                Cell cell = row.getCell(colIndex + j);
                if (cell == null) {
                    cell = row.createCell(colIndex + j);
                }
                if (j < tokens.length) {
                    String cellContent = tokens[j];
                    Double numVal = SpreadsheetUtil.parseNumber(cell, cellContent, this.spreadsheet.getLocale());
                    if (numVal != null) {
                        cell.setCellValue(numVal.doubleValue());
                    } else {
                        cell.setCellValue(cellContent);
                    }
                } else {
                    cell.setBlank();
                    this.spreadsheet.markCellAsDeleted(cell, true);
                }
                this.spreadsheet.getCellValueManager().markCellForUpdate(cell);
                this.spreadsheet.getCellValueManager().getFormulaEvaluator().notifyUpdateCell(cell);
            }
        }
        this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
        this.spreadsheet.updateMarkedCells();
        this.spreadsheet.setSelectionRange(rowIndex, colIndex, rowIndex + pasteHeight - 1, colIndex + pasteWidth - 1);
        this.fireCellValueChangeEvent(affectedRange);
    }

    private void fireCellValueChangeEvent(CellRangeAddress region) {
        HashSet<CellReference> cells = new HashSet<CellReference>();
        for (int x = region.getFirstColumn(); x <= region.getLastColumn(); ++x) {
            for (int y = region.getFirstRow(); y <= region.getLastRow(); ++y) {
                cells.add(new CellReference(y, x));
            }
        }
        this.fireCellValueChangeEvent(cells);
    }

    private void fireCellValueChangeEvent(Set<CellReference> cells) {
        this.spreadsheet.fireEvent(new Spreadsheet.CellValueChangeEvent(this.spreadsheet, cells));
    }

    private static String[] splitOnTab(String line) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, "\t", true);
        boolean lastCharWasTab = false;
        while (tokenizer.hasMoreTokens()) {
            String content = tokenizer.nextToken();
            if (content.equals("\t")) {
                content = "";
                if (!tokenizer.hasMoreTokens()) {
                    lastCharWasTab = true;
                }
            } else if (tokenizer.countTokens() > 1) {
                tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 1) {
                tokenizer.nextToken();
                lastCharWasTab = true;
            }
            list.add(content);
            if (!lastCharWasTab) continue;
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void clearSelectedCellsOnCut() {
        ArrayList<Cell> targetCells = new ArrayList<Cell>();
        List<CellRangeAddress> cellRangeAddresses = this.spreadsheet.getCellSelectionManager().getCellRangeAddresses();
        for (CellRangeAddress a : cellRangeAddresses) {
            for (int row = a.getFirstRow(); row <= a.getLastRow(); ++row) {
                for (int col = a.getFirstColumn(); col <= a.getLastColumn(); ++col) {
                    Cell cell = this.spreadsheet.getCell(row, col);
                    if (cell == null) continue;
                    if (this.spreadsheet.isCellLocked(cell)) {
                        this.protectedCellWriteAttempted();
                        return;
                    }
                    targetCells.add(cell);
                }
            }
        }
        CellReference reference = this.spreadsheet.getCellSelectionManager().getSelectedCellReference();
        Cell cell = this.spreadsheet.getCell(reference.getRow(), reference.getCol());
        if (cell != null) {
            if (this.spreadsheet.isCellLocked(cell)) {
                this.protectedCellWriteAttempted();
                return;
            }
            targetCells.add(cell);
        }
        CellValueCommand command = new CellValueCommand(this.spreadsheet);
        if (reference != null) {
            command.captureCellValues(reference);
        }
        for (CellRangeAddress range : cellRangeAddresses) {
            command.captureCellRangeValues(range);
        }
        this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
        for (Cell targetCell : targetCells) {
            targetCell.setBlank();
            this.spreadsheet.markCellAsDeleted(targetCell, true);
        }
        this.fireCellValueChangeEvent(this.spreadsheet.getSelectedCellReferences());
        this.spreadsheet.refreshAllCellValues();
    }

    @Override
    public void updateCellComment(String text, int col, int row) {
        CreationHelper factory = this.spreadsheet.getWorkbook().getCreationHelper();
        RichTextString str = factory.createRichTextString(text);
        Cell cell = this.getOrCreateCell(this.spreadsheet.getActiveSheet(), row - 1, col - 1);
        Comment comment = cell.getCellComment();
        if (comment == null) {
            Drawing drawingPatriarch = this.spreadsheet.getActiveSheet().createDrawingPatriarch();
            ClientAnchor anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex());
            anchor.setCol2(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex());
            comment = drawingPatriarch.createCellComment(anchor);
            cell.setCellComment(comment);
        }
        comment.setString(str);
    }

    public Cell getOrCreateCell(Sheet sheet, int rowIdx, int colIdx) {
        Cell cell;
        Row row = sheet.getRow(rowIdx);
        if (row == null) {
            row = sheet.createRow(rowIdx);
        }
        if ((cell = row.getCell(colIdx)) == null) {
            cell = row.createCell(colIdx);
        }
        return cell;
    }

    @Override
    public void setGroupingCollapsed(boolean isCols, int colIndex, boolean collapsed) {
        this.spreadsheet.setGroupingCollapsed(isCols, colIndex, collapsed);
    }

    @Override
    public void levelHeaderClicked(boolean isCols, int level) {
        this.spreadsheet.levelHeaderClicked(isCols, level);
    }

    public void onPopupButtonClick(int row, int column) {
        this.spreadsheet.onPopupButtonClick(row, column);
    }

    public void onPopupClose(int row, int column) {
        this.spreadsheet.onPopupClose(row, column);
    }
}

