/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.ClientAnchor;

public class SheetImageWrapper
extends SheetOverlayWrapper
implements Serializable {
    private StreamResource resource;
    private final byte[] data;
    private final String MIMEType;

    public SheetImageWrapper(ClientAnchor anchor, String MIMEType, byte[] data) {
        super(anchor);
        this.MIMEType = MIMEType;
        this.data = data;
    }

    @Override
    public StreamResource getResource() {
        if (this.resource == null) {
            this.resource = new StreamResource(this.getId(), (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(this.data));
            this.resource.setContentType(this.MIMEType);
        }
        return this.resource;
    }

    @Override
    public OverlayInfo.Type getType() {
        return OverlayInfo.Type.IMAGE;
    }
}

